<?php $groups = session('groups') ?? []; ?>

<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }

    thead th, tbody td {
        text-align: center;
        vertical-align: middle;
    }

    .btn-buscar, .btn-crear {
        background-color: #2d5a86;
        color: white;
    }

    .btn-buscar:hover, .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }

    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
    /* Estilos para los encabezados con ordenamiento */
    .sortable-header {
        cursor: pointer;
        position: relative;
        text-decoration: none;
        color: inherit;
        display: block;
        padding: 5px;
    }
    .sortable-header:hover {
        background-color: rgba(255, 255, 255, 0.2);
    }
    .sort-icon {
        font-size: 0.8rem;
        margin-left: 5px;
    }
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }

    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Listado de Válvulas
    </h2>

    <!-- Filtros -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('valvulas') ?>">
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">ID Válvula</label>
            <input type="text" name="id_valvula" class="form-control form-control-sm" value="<?= esc($search['id_valvula'] ?? '') ?>">
        </div>

        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Ubicación</label>
            <input type="text" name="ubicacion" class="form-control form-control-sm" value="<?= esc($search['ubicacion'] ?? '') ?>">
        </div>

        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">OTB</label>
            <input type="text" name="otb" class="form-control form-control-sm" value="<?= esc($search['otb'] ?? '') ?>">
        </div>

        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Distrito</label>
            <input type="text" name="distrito" class="form-control form-control-sm" value="<?= esc($search['distrito'] ?? '') ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Gestion</label>
            <input type="text" name="gestion" class="form-control form-control-sm" value="<?= esc($search['gestion'] ?? '') ?>">
        </div>

        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-buscar">
                <i class="bi bi-search me-1"></i> Buscar válvulas
            </button>
            <a href="<?= base_url('valvulas') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-1"></i> Limpiar
            </a>
        </div>
    </form>
<?php
/*
    <!-- Botón crear -->
    <div class="text-end mb-3">
        <a href="<?= base_url('valvulas/create') ?>" class="btn btn-crear">
            <i class="bi bi-plus-circle"></i> Nueva Válvula
        </a>
    </div>
    */
    ?>
    <!-- shapefile -->
    
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
<?php endif; ?>




<?php if (in_array('sigapas_tecnico', $groups) and in_array('sigapas_valvulas', $groups)): ?>
<div class="row">
    <div class="col-md-3 mb-4" style="color: #2d5a86">  
        <h5 class="mb-3"><b>Nueva Valvula</b>
        </h5>
        <form action="<?= site_url('valvulas/importarShape') ?>" method="post" enctype="multipart/form-data">
            <input type="file" name="shapefile[]" id="shapefile" multiple required class="form-control">
            <small class="form-text text-muted">
                Puedes seleccionar todos los archivos (.shp, .shx, .dbf, .prj, etc.) a la vez.
            </small>
            <div class="text-end mb-3">
                <button type="submit" class="btn btn-importar"><i class="bi bi-plus-circle"></i> Importar</button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>


    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>
                        <?php
                        // Genera el URL para el ordenamiento de esta columna
                        $newOrderDirection = ($orderBy === 'id_valvula' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('valvulas') . '?' . http_build_query(array_merge($search, ['order_by' => 'id_valvula', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            ID Válvula
                            <?php if ($orderBy === 'id_valvula'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-alpha-down' : 'bi-sort-alpha-up' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>Diámetro</th>
                    <th>Tipo</th>
                    <th>Función</th>
                    <th>Estado</th>
                    <th>Tapa</th>
                    <th>Ubicación</th>
                    <th>OTB</th>
                    <th>Distrito</th>
                    <th>Gestion</th>
                    <th>Usuario</th>
                    <th>
                        <?php
                        $newOrderDirection = ($orderBy === 'fecha_usuario' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('valvulas') . '?' . http_build_query(array_merge($search, ['order_by' => 'fecha_usuario', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            Fecha Usuario
                            <?php if ($orderBy === 'fecha_usuario'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-down-alt' : 'bi-sort-down' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="11" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('valvulas/view/' . $item['gid']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <?php if (in_array('sigapas_tecnico', $groups) and in_array('sigapas_valvulas', $groups)): ?>
                                <a href="<?= base_url('valvulas/edit/' . $item['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('valvulas/delete/' . $item['gid']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar esta válvula?');"><i class="bi bi-trash"></i></a>
                                <?php endif; ?>
                                <a href="<?= base_url('valvulas/ver_valvulas_ol/' . $item['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>
                            </td>
                            <td><?= esc($item['id_valvula']) ?></td>
                            <td><?= esc($item['diametro']) ?></td>
                            <td><?= esc($item['tipo']) ?></td>
                            <td><?= esc($item['funcion']) ?></td>
                            <td><?= esc($item['estado']) ?></td>
                            <td><?= esc($item['tapa']) ?></td>
                            <td><?= esc($item['ubicacion']) ?></td>
                            <td><?= esc($item['otb']) ?></td>
                            <td><?= esc($item['distrito']) ?></td>
                            <td><?= esc($item['gestion']) ?></td>
                           <td><?= esc($item['usuario']) ?></td>
                            <td><?= date("d-m-Y H:i:s", strtotime($item['fecha_usuario'])) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection(); ?>






