
<?= $this->extend('templates/blank_page'); ?>

<?= $this->section('menu'); ?>	
	<?= $this->include('templates/menu'); ?>
<?= $this->endSection(); ?>

<?= $this->section('header_contenido'); ?>
	<?= $this->include('templates/header_contenido'); ?>
<?= $this->endSection(); ?>

<?= $this->section('contenido'); ?>

<?= form_open('Usuarios') ?>
    <div>
        <input type="text" name="nombre" value="<?= esc($filters['nombre'] ?? '') ?>" placeholder="Nombre">
        <input type="text" name="apellido" value="<?= esc($filters['apellido'] ?? '') ?>" placeholder="Apellido">
        <input type="text" name="email" value="<?= esc($filters['email'] ?? '') ?>" placeholder="Email">
        <input type="text" name="id_grupo" value="<?= esc($filters['id_grupo'] ?? '') ?>" placeholder="ID Grupo">
        <input type="text" name="id_cliente" value="<?= esc($filters['id_cliente'] ?? '') ?>" placeholder="ID Cliente">
        <button type="submit">Filtrar</button>
    </div>
<?= form_close() ?>

<table>
    <thead>
        <tr>
            <th>Nombre</th>
            <th>Apellido</th>
            <th>Email</th>
            <th>Usuario</th>
            <th>Fecha de Nacimiento</th>
            <th>Grupo</th>
            <th>Cliente</th>
        </tr>
    </thead>
    <tbody>
        <?php if ($usuarios): ?>
            <?php foreach ($usuarios as $usuario): ?>
                <tr>
                    <td><?= esc($usuario->nombre) ?></td>
                    <td><?= esc($usuario->apellido) ?></td>
                    <td><?= esc($usuario->email) ?></td>
                    <td><?= esc($usuario->usuario) ?></td>
                    <td><?= esc($usuario->f_nacimiento) ?></td>
                    <td><?= esc($usuario->id_grupo) ?></td>
                    <td><?= esc($usuario->id_cliente) ?></td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="7">No se encontraron usuarios.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<div>
    <?= $pager ?>
</div>

    </section>
    <!-- /.content -->


<?= $this->endSection(); ?>




