

<!DOCTYPE html>

<?= $this->extend('templates/blank_page'); ?>

<?= $this->section('menu'); ?>	
	<?= $this->include('templates/menu'); ?>
<?= $this->endSection(); ?>

<?= $this->section('header_contenido'); ?>
	<?= $this->include('templates/header_contenido'); ?>
<?= $this->endSection(); ?>

<?= $this->section('contenido'); ?>


<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Usuarios</title>
    <!-- Incluir Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h1 class="mb-4">Listado de Usuarios</h1>

    <a href="<?= base_url('usuarios/create') ?>" class="btn btn-primary mb-3">Crear Usuario</a>

         <!--div class="col-md-3">
    	    <a href="<?= base_url('usuarios/create') ?>" class="btn btn-primary ">Crear Usuario</a>
        </div-->  

    <?php if(session()->getFlashdata('status')): ?>
        <div class="alert alert-success"><?= session()->getFlashdata('status') ?></div>
    <?php endif; ?>

    <!-- Formulario de filtrado -->
    <form method="get" action="<?= base_url('Usuarios') ?>" class="row g-3 mb-4">

        <div class="col-md-3">
            <input type="text" name="nombre" class="form-control" placeholder="Nombre" value="<?= esc($filters['nombre'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="apellido" class="form-control" placeholder="Apellido" value="<?= esc($filters['apellido'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <input type="text" name="email" class="form-control" placeholder="Email" value="<?= esc($filters['email'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="number" name="id_grupo" class="form-control" placeholder="ID Grupo" value="<?= esc($filters['id_grupo'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="number" name="id_cliente" class="form-control" placeholder="ID Cliente" value="<?= esc($filters['id_cliente'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <button type="submit" class="btn btn-primary">Filtrar</button>
        </div>
        <div class="col-md-3">
            <a href="<?= base_url('Usuarios') ?>" class="btn btn-secondary">Limpiar filtros</a>
        </div>
    </form>

    <!-- Tabla de usuarios -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
					<th>Acciones</th>
                    <th>Nombre</th>
                    <th>Apellido</th>
                    <th>Email</th>
                    <th>Usuario</th>
                    <th>Fecha de Nacimiento</th>
                    <th>ID Grupo</th>
                    <th>ID Cliente</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($usuarios): ?>
                    <?php foreach ($usuarios as $usuario): ?>
                        <tr>
                    <td>
                        <a href="<?= base_url('usuarios/edit/'.esc($usuario->id_usuario)) ?>" class="btn btn-warning">Editar</a>
                        <a href="<?= base_url('usuarios/delete/'.esc($usuario->id_usuario)) ?>" class="btn btn-danger" onclick="return confirm('¿Estás seguro de eliminar este usuario?');">Eliminar</a>
                    </td>                    
                            <td><?= esc($usuario->nombre) ?></td>
                            <td><?= esc($usuario->apellido) ?></td>
                            <td><?= esc($usuario->email) ?></td>
                            <td><?= esc($usuario->usuario) ?></td>
                            <td><?= esc($usuario->f_nacimiento) ?></td>
                            <td><?= esc($usuario->id_grupo) ?></td>
                            <td><?= esc($usuario->id_cliente) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center">No se encontraron usuarios.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Paginación -->
    <div class="d-flex justify-content-center">
        <?= $pager ?>
    </div>
</div>

<!-- Incluir Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?= $this->endSection(); ?>




