<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">
<div class="container mt-4">
    <h2 class="text-center mb-4 fw-bold" style="color: #2d5a86;">Detalle del Usuario</h2>

    <div class="row g-3">
        <div class="col-md-6">
            <label class="form-label fw-bold">Username</label>
            <div class="form-control bg-light"><?= esc($item['username']) ?></div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-bold">Email</label>
            <div class="form-control bg-light"><?= esc($item['email']) ?></div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-bold">Nombre</label>
            <div class="form-control bg-light"><?= esc($item['nombre']) ?></div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-bold">Apellido</label>
            <div class="form-control bg-light"><?= esc($item['apellido']) ?></div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-bold">Estado</label>
            <div class="form-control bg-light"><?= esc($item['estado']) ?></div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-bold">Activo</label>
            <div class="form-control bg-light"><?= $item['active'] ? 'Sí' : 'No' ?></div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-bold">Creado en</label>
            <div class="form-control bg-light">
                <?php
                    $fecha = \DateTime::createFromFormat('Y-m-d H:i:s', $item['created_at']);
                    echo $fecha ? $fecha->format('d \d\e F \d\e Y, H:i') : esc($item['created_at']);
                ?>
            </div>
        </div>
    </div>

    <div class="text-end mt-4">
        <a href="<?= base_url('users/edit/' . $item['id']) ?>" class="btn btn-primary"><i class="bi bi-pencil-square"></i> Editar</a>
        <a href="<?= base_url('users') ?>" class="btn btn-secondary"><i class="bi bi-arrow-left-circle"></i> Volver</a>
    </div>
</div>
<?= $this->endSection(); ?>
