
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">
<div class="container mt-4">
    <h2 class="text-center mb-4 fw-bold" style="color: #2d5a86;">Editar Usuario</h2>
    <form action="<?= base_url('users/update/' . $item['id']) ?>" method="post">
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label fw-bold">Username</label>
                <input type="text" name="username" class="form-control" value="<?= esc($item['username']) ?>" required>
            </div>
            <div class="col-md-6">
                <label class="form-label fw-bold">Nueva Contraseña</label>
                <input type="password" name="password_hash" class="form-control" placeholder="(Opcional)">
            </div>
            <div class="col-md-6">
                <label class="form-label fw-bold">Email</label>
                <input type="email" name="email" class="form-control" value="<?= esc($item['email']) ?>">
            </div>
            <div class="col-md-6">
                <!--label class="form-label fw-bold">Estado</label-->
                <!--input type="text" name="estado" class="form-control" value="<?= esc($item['estado']) ?>"-->
                
            <div class="col-md-6">
                <label class="form-label fw-bold">Estado</label>
                <select name="estado" class="form-select">
                    <option value="A" <?= ($item['estado'] === 'A') ? 'selected' : '' ?>>Activo</option>
                    <option value="N" <?= ($item['estado'] === 'N') ? 'selected' : '' ?>>Inactivo</option>
                </select>
            </div>
                
            </div>
            <div class="col-md-6">
                <label class="form-label fw-bold">Nombre</label>
                <input type="text" name="nombre" class="form-control" value="<?= esc($item['nombre']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label fw-bold">Apellido</label>
                <input type="text" name="apellido" class="form-control" value="<?= esc($item['apellido']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label fw-bold">Activo</label>
                <select name="active" class="form-select">
                <option value="1" <?= ($item['active'] == 1) ? 'selected' : '' ?>>Sí</option>
                <option value="0" <?= ($item['active'] == 0) ? 'selected' : '' ?>>No</option>
                </select>
            </div>
            <div class="col-md-12">
                <label class="form-label fw-bold">Roles</label>
                <div class="form-check">
                    <?php foreach ($groups as $group): ?>
                        <div class="form-check">
                            <input class="form-check-input" 
                                   type="checkbox" 
                                   name="groups[]" 
                                   value="<?= $group['id'] ?>"
                                   <?= in_array($group['id'], $userGroups) ? 'checked' : '' ?>>
                            <label class="form-check-label">
                                <?= esc($group['name']) ?> - <small><?= esc($group['description']) ?></small>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        </div>
        <div class="text-end mt-4">
            <button type="submit" class="btn btn-primary"><i class="bi bi-save"></i> Actualizar</button>
            <a href="<?= base_url('users') ?>" class="btn btn-secondary"><i class="bi bi-arrow-left-circle"></i> Cancelar</a>
        </div>
    </form>
</div>
<?= $this->endSection(); ?>
