
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Editar Red de Alcantarillado
    </h2>

    <form method="post" action="<?= base_url('red_alcantarillado/update/' . $item['gid']) ?>" enctype="multipart/form-data">
        <?= csrf_field() ?>

        <!-- Grupo 1: Identificación -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold text-primary">Identificación</legend>
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label fw-bold">ID Tubería <span class="text-danger">*</span></label>
                    <input type="text" name="id_tuberia" class="form-control form-control-sm" value="<?= esc($item['id_tuberia']) ?>" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-bold">Gestion <span class="text-danger">*</span></label>
                    <input type="text" name="gestion" class="form-control form-control-sm" value="<?= esc($item['gestion']) ?>" required>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Características -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold text-primary">Características</legend>
            <div class="row g-2">
                <?php
                    $caracteristicas = [
                        'diametro' => 'Diámetro',
                        'longitud' => 'Longitud (m2)',
                        'material' => 'Material',
                        'tipo_tuberia' => 'Tipo Tubería',
                        'profundidad' => 'Profundidad',
                        'estado_actual' => 'Estado Actual',
                        'pendiente' => 'Pendiente'
                    ];
                    $camposRequeridos = ['diametro', 'estado_actual', 'tipo_tuberia', 'material'];
                    foreach ($caracteristicas as $campo => $label): ?>
                        <div class="col-md-3">
                            <label class="form-label fw-bold"><?= $label ?>
                            <?php if (in_array($campo, $camposRequeridos)): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                            </label>
                            
                            <?php if ($campo === 'estado_actual'): ?>
                            <select name="estado_actual" id="estado_actual" class="form-control form-control-sm" <?= in_array('estado_actual', $camposRequeridos) ? 'required' : '' ?>>
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($estadoActual as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>" <?= $item['estado_actual'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php else: ?>
                                <?php if ($campo === 'tipo_tuberia'): ?>
                                <select name="tipo_tuberia" id="tipo_tuberia" class="form-control form-control-sm" <?= in_array('tipo_tuberia', $camposRequeridos) ? 'required' : '' ?>>
                                    <option value="">-- Seleccione --</option>
                                    <?php foreach ($tipoTuberia as $opcion): ?>
                                        <option value="<?= esc($opcion['concepto']) ?>" <?= $item['tipo_tuberia'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <?php else: ?>
                                    <input type="text" name="<?= $campo ?>" class="form-control form-control-sm" value="<?= esc($item[$campo]) ?>" <?= in_array($campo, $camposRequeridos) ? 'required' : '' ?>
                                    <?= $campo === 'longitud' ? 'readonly' : '' ?>>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Ubicación -->
    <fieldset class="border p-2 mb-2">
    <legend class="w-auto px-2 fw-bold text-primary">Ubicación</legend>
    <div class="row g-2">
        <?php
        $ubicacion = [
            'calle' => 'Calle',
            'ubicacion' => 'Ubicación',
            'otb' => 'OTB',
            'distrito' => 'Distrito',
            'municipio' => 'Municipio',
            'provincia' => 'Provincia',
            'departamento' => 'Departamento'
        ];

        $soloLectura = ['otb', 'distrito', 'municipio', 'provincia', 'departamento'];

        foreach ($ubicacion as $campo => $label): ?>
            <div class="col-md-3">
                <label class="form-label fw-bold"><?= $label ?></label>

                <?php if (in_array($campo, $soloLectura)): ?>
                    <!-- Solo lectura -->
                    <input type="text"
                           id="<?= $campo ?>"
                           value="<?= esc($item[$campo] ?? '') ?>"
                           class="form-control form-control-sm"
                           readonly>
                <?php else: ?>
                    <!-- Editable -->
                    <input type="text"
                           name="<?= $campo ?>"
                           id="<?= $campo ?>"
                           value="<?= esc($item[$campo] ?? '') ?>"
                           class="form-control form-control-sm">
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
    </fieldset>


        <!-- Grupo 4: Otros -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Otros</legend>
            <div class="row g-2">
                <div class="col-md-4">
                    <label class="form-label fw-bold">Responsable</label>
                    <input type="text" name="responsable" class="form-control form-control-sm" value="<?= esc($item['responsable']) ?>">
                </div>
                <div class="col-md-8">
                    <label class="form-label fw-bold">Observaciones</label>
                    <textarea name="observaciones" rows="3" class="form-control form-control-sm"><?= esc($item['observaciones']) ?></textarea>
                </div>
            </div>
        </fieldset>

        <div class="text-center mt-3">
            <button type="submit" class="btn btn-primary px-4">Guardar Cambios</button>
            <a href="<?= base_url('red_alcantarillado') ?>" class="btn btn-secondary px-4 ms-2">Cancelar</a>
        </div>
    </form>
</div>
<?= $this->endSection(); ?>

