<?php $groups = session('groups') ?? []; ?>

<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }
    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
    /* Estilos para los encabezados con ordenamiento */
    .sortable-header {
        cursor: pointer;
        position: relative;
        text-decoration: none;
        color: inherit;
        display: block;
        padding: 5px;
    }
    .sortable-header:hover {
        background-color: rgba(255, 255, 255, 0.2);
    }
    .sort-icon {
        font-size: 0.8rem;
        margin-left: 5px;
    }
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Red de Agua Potable
    </h2>

    <!-- Formulario de filtros -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('red_agua_potable') ?>">
        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">ID Tubería</label>
            <input type="text" name="id_tuberia" class="form-control form-control-sm" value="<?= esc($search['id_tuberia'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Calle</label>
            <input type="text" name="calle" class="form-control form-control-sm" value="<?= esc($search['calle'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Estado Actual</label>
            <input type="text" name="estado_actual" class="form-control form-control-sm" value="<?= esc($search['estado_actual'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Responsable</label>
            <input type="text" name="responsable" class="form-control form-control-sm" value="<?= esc($search['responsable'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Distrito</label>
            <input type="text" name="distrito" class="form-control form-control-sm" value="<?= esc($search['distrito'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">OTB</label>
            <input type="text" name="otb" class="form-control form-control-sm" value="<?= esc($search['otb'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Gestion</label>
            <input type="text" name="gestion" class="form-control form-control-sm" value="<?= esc($search['gestion'] ?? '') ?>">
        </div>

        <!-- Botones -->
        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-buscar">
                <i class="bi bi-search me-1"></i> Buscar
            </button>
            <a href="<?= base_url('red_agua_potable') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-1"></i> Limpiar búsqueda
            </a>
        </div>
    </form>
    
    <?php
    /*
   <!-- Botón Crear -->
    <div class="text-end mb-3">
        <a href="<?= base_url('red_agua_potable/create') ?>" class="btn btn-crear">
            <i class="bi bi-plus-circle"></i> Nueva Tubería
        </a>
    </div>
    */
    ?>
    

<!-- shapefile -->
    
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
<?php endif; ?>



<?php if (in_array('sigapas_tecnico', $groups) and in_array('sigapas_red_agua_potable', $groups)): ?>
<div class="row">
    <div class="col-md-3 mb-4" style="color: #2d5a86">  
        <h5 class="mb-3"><b>Nueva Tuberia</b>
            
        </h5>
        <form action="<?= site_url('red_agua_potable/importarShape') ?>" method="post" enctype="multipart/form-data">
            
            <input type="file" name="shapefile[]" id="shapefile" multiple required class="form-control">
            <small class="form-text text-muted">
                Puedes seleccionar todos los archivos (.shp, .shx, .dbf, .prj, etc.) a la vez.
            </small>
            
            <div class="text-end mb-3">
                
                <button type="submit" class="btn btn-importar"><i class="bi bi-plus-circle"></i> Importar</button>
            
            
            </div>
        </form>

    </div>
</div>
<?php endif; ?>


    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>
                        <?php
                        // Genera el URL para el ordenamiento de esta columna
                        $newOrderDirection = ($orderBy === 'id_tuberia' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('red_agua_potable') . '?' . http_build_query(array_merge($search, ['order_by' => 'id_tuberia', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            ID Tubería
                            <?php if ($orderBy === 'id_tuberia'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-alpha-down' : 'bi-sort-alpha-up' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>Calle</th>
                    <th>Estado Actual</th>
                    <th>Responsable</th>
                    <th>Ubicación</th>
                    <th>Distrito</th>
                    <th>OTB</th>
                    <th>Usuario</th>
                    <th>Gestion</th>
                    <th>
                        <?php
                        $newOrderDirection = ($orderBy === 'fecha_usuario' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('red_agua_potable') . '?' . http_build_query(array_merge($search, ['order_by' => 'fecha_usuario', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            Fecha Usuario
                            <?php if ($orderBy === 'fecha_usuario'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-down-alt' : 'bi-sort-down' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('red_agua_potable/view/' . $item['gid']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <?php if (in_array('sigapas_tecnico', $groups) and in_array('sigapas_red_agua_potable', $groups)): ?>
                                <a href="<?= base_url('red_agua_potable/edit/' . $item['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('red_agua_potable/delete/' . $item['gid']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar este registro?');"><i class="bi bi-trash"></i></a>
                                <?php endif; ?>
                                <a href="<?= base_url('red_agua_potable/ver_red_agua_potable_ol/' . $item['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>
                            </td>
                            <td><?= esc($item['id_tuberia']) ?></td>
                            <td><?= esc($item['calle']) ?></td>
                            <td><?= esc($item['estado_actual']) ?></td>
                            <td><?= esc($item['responsable']) ?></td>
                            <td><?= esc($item['ubicacion']) ?></td>
                            <td><?= esc($item['distrito']) ?></td>
                            <td><?= esc($item['otb']) ?></td>
                            <td><?= esc($item['gestion']) ?></td>
                            <td><?= esc($item['usuario']) ?></td>
                            <td><?= date("d-m-Y H:i:s", strtotime($item['fecha_usuario'])) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection(); ?>

