
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Organizaciones Territoriales de Base (OTBs)
    </h2>

    <!-- Formulario de filtros -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('otbs') ?>">
        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">ID OTB</label>
            <input type="text" name="id_otb" class="form-control form-control-sm" value="<?= esc($search['id_otb'] ?? '') ?>">
        </div>
        
        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Nombre OTB</label>
            <input type="text" name="nombres_otb" class="form-control form-control-sm" value="<?= esc($search['nombres_otb'] ?? '') ?>">
        </div>


        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Distrito</label>
            <input type="text" name="distritos" class="form-control form-control-sm" value="<?= esc($search['distritos'] ?? '') ?>">
        </div>

        

        <!-- Botones -->
        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-buscar">
                <i class="bi bi-search me-1"></i> Buscar
            </button>
            <a href="<?= base_url('otbs') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-1"></i> Limpiar búsqueda
            </a>
        </div>
    </form>

    <!-- Botón Crear -->
    <div class="text-end mb-3">
        <a href="<?= base_url('otbs/create') ?>" class="btn btn-crear">
            <i class="bi bi-plus-circle"></i> Nueva OTB
        </a>
    </div>

    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                   <th>ID OTB</th>
                    <th>Nombre OTB</th>
                    <th>Distrito</th>
                    
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('otbs/view/' . $item['gid']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <a href="<?= base_url('otbs/edit/' . $item['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('otbs/delete/' . $item['gid']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar este registro?');"><i class="bi bi-trash"></i></a>
                                <a href="<?= base_url('otbs/ver_otbs_ol/' . $item['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>
                            </td>
                            <td><?= esc($item['id_otb']) ?></td>
                            <td><?= esc($item['nombres_otb']) ?></td>
                            <td><?= esc($item['distritos']) ?></td>
                            
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection(); ?>

