<?php
// app/Views/expedientes/mantenimiento_view.php

// No es necesario 'defined('BASEPATH') OR exit('No direct script access allowed');' en CI4 views.
?>

<script src="https://cdn.tailwindcss.com"></script>
<script>
  tailwind.config = {
    theme: {
      extend: {
        fontFamily: {
          sans: ['Inter', 'sans-serif'],
        },
      }
    }
  }
</script>

<style>
  /* Custom styles for a cleaner look, complementing Tailwind */
  body {
    font-family: 'Inter', sans-serif;
  }
  .tab-active {
    background-color: #F0F0F0; /* Light gray background for active tab */
    border-top-left-radius: 0.5rem;
    border-top-right-radius: 0.5rem;
  }
  .box-shadow {
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
  }
  .file-input-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 1.5rem;
    border: 2px dashed #cbd5e0; /* gray-300 */
    border-radius: 0.5rem;
    background-color: #f7fafc; /* gray-50 */
    text-align: center;
    cursor: pointer;
    transition: all 0.2s ease-in-out;
  }
  .file-input-container:hover {
    border-color: #a0aec0; /* gray-400 */
    background-color: #edf2f7; /* gray-100 */
  }
  .file-input-container input[type="file"] {
    display: none; /* Hide default file input */
  }
</style>

<div class="min-h-screen bg-gray-100 flex flex-col items-center py-8 px-4 sm:px-6 lg:px-8">
    <!-- Contenido principal: Encabezado y Breadcrumb -->
    <section class="w-full max-w-7xl mx-auto mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-center pb-4 border-b border-gray-200">
            <h1 class="text-3xl font-extrabold text-gray-900 mb-2 sm:mb-0"><?= $pagetitle ?? 'Título de la Página' ?></h1>
            <nav class="text-sm text-gray-600" aria-label="breadcrumb">
                <?= $breadcrumb ?? 'Inicio > Expedientes' ?>
            </nav>
        </div>
    </section>

    <!-- Sección de Contenido Principal -->
    <section class="w-full max-w-7xl mx-auto">
        <div class="bg-white rounded-lg shadow-lg overflow-hidden">
            <!-- Pestañas de Navegación -->
            <div class="border-b border-gray-200">
                <ul class="flex -mb-px">
                    <li class="mr-2">
                        <!-- La URL debe apuntar a una ruta de CodeIgniter 4, por ejemplo, usando url_to() -->
                        <a href="<?= base_url('cuest/reg01/vista_reg01') ?>" class="inline-block py-3 px-6 text-sm font-medium text-blue-600 border-b-2 border-blue-600 rounded-t-lg tab-active" aria-current="page">Mantenimiento</a>
                    </li>
                    <!-- Si hubiera más pestañas, se añadirían aquí. Ejemplo comentado: -->
                    <!-- <li>
                        <a href="<?= url_to('ExpedientesController::dictamenA', $expe_info[0]['expe_id'] ?? '') ?>" class="inline-block py-3 px-6 text-sm font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300 rounded-t-lg">Dictamen A</a>
                    </li> -->
                </ul>
            </div>

            <!-- Contenido de las Pestañas -->
            <div class="p-6 bg-gray-50">
                <div id="tab_1" class="tab-pane active">
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Bloque Información Expediente -->
                        <div class="w-full md:w-1/3">
                            <div class="bg-white rounded-lg shadow-md box-shadow">
                                <div class="p-4 border-b border-gray-200 bg-blue-500 text-white rounded-t-lg">
                                    <h3 class="text-xl font-semibold">Información Expediente</h3>
                                </div>
                                <div class="p-4">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            <?php if (isset($expe_info) && is_array($expe_info)): ?>
                                                <?php foreach ($expe_info as $expe): ?>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.id') ?? 'ID' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['id'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.codigo') ?? 'Código' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['codigo'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.tramo') ?? 'Tramo' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['des_tramo'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.subtramo') ?? 'Subtramo' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['subtramo'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.nombre_y_apellido') ?? 'Nombre y Apellido' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['nombre_completo'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.tipo_afectacion') ?? 'Tipo Afectación' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['des_tipo_afectacion'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.estado') ?? 'Estado' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['seg_estado'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.franja') ?? 'Franja' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['franja_dominio'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                            <?= lang('Expedientes.ubi_supervisor') ?? 'Ubi Supervisor' ?>
                                                        </th>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                            <?= esc($expe['ubi_supervisor'] ?? '') ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <tr>
                                                    <td colspan="2" class="px-3 py-2 text-center text-sm text-gray-500">No hay información de expediente disponible.</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                    <hr class="my-4 border-gray-200">
                                    <div class="flex justify-center mt-4">
                                        <a href="<?= url_to('ExpedientesController::index') ?>" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-gray-600 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                                            ATRAS
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- FIN Bloque Información Expediente -->

                        <!-- Bloque Datos Gráficos -->
                        <div class="w-full md:w-2/3">
                            <div class="bg-white rounded-lg shadow-md box-shadow">
                                <div class="p-4 border-b border-gray-200 bg-green-500 text-white rounded-t-lg">
                                    <h3 class="text-xl font-semibold">Mantenimiento - Datos Gráficos</h3>
                                </div>
                                <div class="p-4">
                                    <?php if (isset($message)): ?>
                                        <div class="bg-blue-100 border-l-4 border-blue-500 text-blue-700 p-4 mb-4" role="alert">
                                            <p class="font-bold">Mensaje:</p>
                                            <p><?= esc($message) ?></p>
                                        </div>
                                    <?php endif; ?>

                                    <div class="mb-6">
                                        <table class="min-w-full divide-y divide-gray-200">
                                            <tbody class="bg-white divide-y divide-gray-200">
                                                <?php if (isset($datos_graficos) && is_array($datos_graficos)): ?>
                                                    <?php foreach ($datos_graficos as $expe_grf): ?>
                                                        <tr>
                                                            <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                                POLÍGONO TÍTULO
                                                            </th>
                                                            <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                                                <?= esc($expe_grf['TERRENOS_CI'] ?? '') ?>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="2" class="px-3 py-2 text-center text-sm text-gray-500">No hay datos gráficos disponibles.</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- Formulario de Importación de Shapes -->
                                    <form action="<?= url_to('ExpedientesController::importarShapes') ?>" method="post" enctype="multipart/form-data" class="space-y-6">
                                        <?= csrf_field() ?>
                                        <label for="shapes" class="file-input-container">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 0115.9 6L16 6a3 3 0 013 3v10a2 2 0 01-2 2H7a2 2 0 01-2-2v-3a1 1 0 012 0v3z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 17l-4-4m0 0l-4 4m4-4v9" />
                                            </svg>
                                            <span class="mt-2 text-gray-600 text-sm font-medium">Arrastra y suelta archivos aquí o haz clic para seleccionar una carpeta de shapes</span>
                                            <input id="shapes" name="shapes[]" type="file" multiple webkitdirectory directory accept=".shp,.shx,.dbf,.prj,.cpg">
                                        </label>

                                        <!-- Campos ocultos (asumiendo que $id, $codigo, $id_proyecto son arrays o stdClass) -->
                                        <?php if (isset($id)): ?>
                                            <input type="hidden" name="id" value="<?= esc($id['value'] ?? '') ?>">
                                        <?php endif; ?>
                                        <?php if (isset($codigo)): ?>
                                            <input type="hidden" name="codigo" value="<?= esc($codigo['value'] ?? '') ?>">
                                        <?php endif; ?>
                                        <?php if (isset($id_proyecto)): ?>
                                            <input type="hidden" name="id_proyecto" value="<?= esc($id_proyecto['value'] ?? '') ?>">
                                        <?php endif; ?>

                                        <!-- Sección de botones -->
                                        <div class="flex flex-wrap justify-center gap-4 mt-6">
                                            <?php
                                            // Asumiendo que $expe está disponible y tiene 'id', 'id_proyecto', 'codigo'
                                            // y que la función grupo_usuario(3) se maneja en el controlador o un helper CI4
                                            // Para simplificar, se muestra el botón.
                                            $expe_id = $expe['id'] ?? '';
                                            $expe_id_proyecto = $expe['id_proyecto'] ?? '';
                                            $expe_codigo = $expe['codigo'] ?? '';
                                            ?>
                                            <a href="<?= url_to('ExpedientesController::eliminarGeometrias', $expe_id, $expe_id_proyecto, $expe_codigo) ?>" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                                Eliminar
                                            </a>

                                            <button type="submit" name="accion" value="1" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                                Importar
                                            </button>

                                            <a href="<?= url_to('ExpedientesController::downloadExpe', $expe_id) ?>" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                                                Descargar
                                            </a>

                                            <?php
                                            // Asumiendo que la condición grupo_usuario(3) se maneja en el controlador o un helper CI4
                                            // Para simplificar, se muestra el botón.
                                            ?>
                                            <a href="<?= url_to('ExpedientesController::verGrafico', $expe_codigo, $expe_id) ?>" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                                VISOR
                                            </a>
                                        </div>
                                    </form>

                                    <!-- Segundo formulario (vacío en el original, se mantiene la estructura) -->
                                    <form action="<?= url_to('ExpedientesController::actualizarCoordAfecta') ?>" method="post" class="mt-6">
                                        <?= csrf_field() ?>
                                        <?php if (isset($id)): ?>
                                            <input type="hidden" name="id" value="<?= esc($id['value'] ?? '') ?>">
                                        <?php endif; ?>
                                        <!-- Otros campos si son necesarios para este formulario -->
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- FIN Bloque Datos Gráficos -->
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

