<?php
function render_input_fields(array $campos, array $datos = [], array $tipos_especiales = [], $col = 'col-md-3') {
    foreach ($campos as $campo) {
        $type = $tipos_especiales[$campo] ?? 'text';
        $label = ucfirst(str_replace('_', ' ', $campo));
        $valor = esc($datos[$campo] ?? '');

        echo '<div class="' . $col . '">';
        echo '<label class="form-label fw-bold text-sm" style="color: #000;">' . $label . '</label>';
        echo '<input type="' . $type . '" class="form-control form-control-sm" name="' . $campo . '" value="' . $valor . '">';
        echo '</div>';
    }
}
?>

<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
  
</style>


<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Editar Medidor
    </h2>
    <form action="<?= base_url('medidores/update/' . $medidor['gid']) ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>



        <!-- Grupo 1: Código -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Código</legend>
            <div class="row">
                <div class="col-md-4">
                    <label for="cod_fijo" class="form-label fw-bold">Código Fijo <span class="text-danger">*</span>
                    </label>
                    <input type="text" name="cod_fijo" id="cod_fijo" value="<?= esc($medidor['cod_fijo']) ?>" class="form-control form-control-sm" required>
                </div>
                <div class="col-md-4">
                    <label for="gestion" class="form-label fw-bold">Gestion <span class="text-danger">*</span>
                    </label>
                    <input type="text" name="gestion" id="gestion" value="<?= esc($medidor['gestion']) ?>" class="form-control form-control-sm" required>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Usuario -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Usuario</legend>
            <div class="row g-2">
                <?php
                $campos = [
                    'cod_usuario' => 'Código Usuario',
                    'nombres' => 'Nombres',
                    'apellidos' => 'Apellidos',
                    'direccion' => 'Dirección',
                    'num_casa' => 'Número Casa',
                    'nit_ci' => 'NIT/CI',
                    'tipo_vivienda' => 'Tipo Vivienda',
                    'categoria' => 'Categoría'
                ];
                
                $camposRequeridos = ['cod_usuario', 'nombres', 'apellidos', 'direccion', 'num_casa', 'nit_ci'];
                foreach ($campos as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?>
                            <?php if (in_array($campo, $camposRequeridos)): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
                        <?php if ($campo === 'tipo_vivienda'): ?>
                            <select name="tipo_vivienda" id="tipo_vivienda" class="form-control form-control-sm">
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($tipoVivienda as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>" <?= $medidor['tipo_vivienda'] === $opcion['concepto'] ? 'selected' : '' ?>>
                                        <?= esc($opcion['nombre']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        <?php elseif ($campo === 'categoria'): ?>
                            <select name="categoria" id="categoria" class="form-control form-control-sm">
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($categoria as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>" <?= $medidor['categoria'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php else: ?>
                            <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm" <?= in_array($campo, $camposRequeridos) ? 'required' : '' ?>>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Acometida -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Acometida</legend>
            <div class="row g-2">
                <?php
                $acometida = [
                    'diam_acometida' => 'Diámetro Acometida',
                    'mat_tub_acometida' => 'Material Tubo',
                    'numero_medidor' => 'Número Medidor',
                    'marca_medidor' => 'Marca Medidor'
                ];
                
                $camposRequeridos = ['diam_acometida', 'mat_tub_acometida', 'numero_medidor', 'marca_medidor'];
                foreach ($acometida as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold">
                            <?= $label ?>
                            <?php if (in_array($campo, $camposRequeridos)): ?>
                                <span class="text-danger">*</span>
                            <?php endif; ?>
                        </label>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm" <?= in_array($campo, $camposRequeridos) ? 'required' : '' ?>>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

       <!-- Grupo 4: Ubicación -->
    <fieldset class="border p-2 mb-3">
    <legend class="w-auto px-2 fw-bold text-primary">Ubicación</legend>
    <div class="row g-2">
        <?php
        $ubicacion = [
            'ubicacion', 'este', 'norte', 'cota',
            'otb', 'distrito', 'municipio', 'provincia', 'departamento'
        ];

        $soloLectura = ['este', 'norte', 'otb', 'distrito', 'municipio', 'provincia', 'departamento'];

        foreach ($ubicacion as $campo): ?>
            <div class="col-md-3">
                <label for="<?= $campo ?>" class="form-label fw-bold"><?= ucfirst($campo) ?>
                    <?php if ($campo === 'ubicacion'): ?>
                        <span class="text-danger">*</span>
                    <?php endif; ?>
                </label>

                <?php if ($campo === 'ubicacion'): ?>
                    <!-- Campo editable con SELECT -->
                    <select name="ubicacion" id="ubicacion" class="form-control form-control-sm" required>
                        <option value="">-- Seleccione --</option>
                        <?php foreach ($ubicacionOpciones as $opcion): ?>
                            <option value="<?= esc($opcion['concepto']) ?>" 
                                <?= $medidor['ubicacion'] === $opcion['concepto'] ? 'selected' : '' ?>>
                                <?= esc($opcion['nombre']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>

                <?php elseif (in_array($campo, $soloLectura)): ?>
                    <!-- Solo lectura -->
                    <input type="text"
                           id="<?= $campo ?>"
                           value="<?= esc($medidor[$campo] ?? '') ?>"
                           class="form-control form-control-sm"
                           readonly>

                <?php else: ?>
                    <!-- Editable (ejemplo: cota) -->
                    <input type="text"
                           name="<?= $campo ?>"
                           id="<?= $campo ?>"
                           value="<?= esc($medidor[$campo] ?? '') ?>"
                           class="form-control form-control-sm">
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
    </fieldset>


        <!-- Grupo 5: Abastecimiento y Lectura -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Abastecimiento y Lectura</legend>
            <input type="hidden" name="page" value="<?= esc($page ?? 1) ?>">
            <div class="row g-2">
                <?php
                $lectura = [
                    'zona_abast', 'zona_cod_comercial',
                    'lectura_inicial', 'fecha_lect_inicial',
                    'lectura_final', 'fecha_lect_final'
                ];
                foreach ($lectura as $campo): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= ucfirst(str_replace('_', ' ', $campo)) ?></label>
                        <input type="<?= strpos($campo, 'fecha') !== false ? 'date' : 'text' ?>" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 6: Instalación -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Instalación</legend>
            <div class="row g-2">
                <?php
                $instalacion = [
                    'inst_con_liberacion', 'usu_funcionario', 'fecha_instalacion',
                    'estado_registro', 'tipo_lectura', 'control_datos_crc'
                ];
                foreach ($instalacion as $campo): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= ucfirst(str_replace('_', ' ', $campo)) ?></label>
                    <?php if ($campo === 'inst_con_liberacion'): ?>
                        <select name="inst_con_liberacion" id="inst_con_liberacion" class="form-control form-control-sm">
                            <option value="">-- Seleccione --</option>
                            <?php foreach ($instLiberacion as $opcion): ?>
                                <option value="<?= esc($opcion['concepto']) ?>" <?= $medidor['inst_con_liberacion'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    <?php else: ?>
                        <?php if ($campo === 'usu_funcionario'): ?>
                            <select name="usu_funcionario" id="usu_funcionario" class="form-control form-control-sm">
                                <option value="">-- Seleccione --</option>
                                <?php foreach ($usuarioFuncionario as $opcion): ?>
                                    <option value="<?= esc($opcion['concepto']) ?>" <?= $medidor['usu_funcionario'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <?php if ($campo === 'estado_registro'): ?>
                                <select name="estado_registro" id="estado_registro" class="form-control form-control-sm">
                                    <option value="">-- Seleccione --</option>
                                    <?php foreach ($estadoRegistro as $opcion): ?>
                                        <option value="<?= esc($opcion['concepto']) ?>" <?= $medidor['estado_registro'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            <?php else: ?>
                                <?php if ($campo === 'tipo_lectura'): ?>
                                    <select name="tipo_lectura" id="tipo_lectura" class="form-control form-control-sm">
                                        <option value="">-- Seleccione --</option>
                                        <?php foreach ($tipoLectura as $opcion): ?>
                                            <option value="<?= esc($opcion['concepto']) ?>" <?= $medidor['tipo_lectura'] === $opcion['concepto'] ? 'selected' : '' ?>><?= esc($opcion['nombre']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                        
                        <input type="<?= strpos($campo, 'fecha') !== false ? 'date' : 'text' ?>" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm">
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>                        
                    <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            
                <div class="col-md-4">
                    <label for="foto_inicial" class="form-label fw-bold">Foto Inicial</label>
                    <input type="file" name="foto_inicial" id="foto_inicial" class="form-control form-control-sm mb-2" accept="image/*">
                
                    <!-- Contenedor único para la previsualización de la imagen -->
                    <div id="image_preview_wrapper" class="position-relative d-inline-block mt-2 <?= !empty($medidor['foto_inicial']) ? '' : 'd-none' ?>">
                        <img id="preview_imagen" src="<?= !empty($medidor['foto_inicial']) ? base_url('uploads/fotos/' . $medidor['foto_inicial']) : '' ?>" class="img-thumbnail" width="200">
                        <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0" id="btnEliminarImagen" style="transform: translate(25%, -25%); border-radius: 50%;">&times;</button>
                        <input type="hidden" name="eliminar_foto" id="eliminar_foto" value="<?= !empty($medidor['foto_inicial']) ? '0' : '1' ?>">
                    </div>
                </div>
            </div>
        </fieldset>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const inputFile = document.getElementById('foto_inicial');
    const imagePreviewWrapper = document.getElementById('image_preview_wrapper'); // Nuevo contenedor único
    const previewImg = document.getElementById('preview_imagen');
    const btnEliminarImagen = document.getElementById('btnEliminarImagen'); // Nuevo botón único
    const eliminarInput = document.getElementById('eliminar_foto');

    // --- Control de visibilidad inicial (basado en PHP) ---
    // El estado inicial del wrapper y el input oculto ya se maneja en el HTML con PHP.
    // Solo necesitamos asegurar que el botón de eliminar imagen esté visible si hay una imagen.
    if (btnEliminarImagen && imagePreviewWrapper && !imagePreviewWrapper.classList.contains('d-none')) {
        btnEliminarImagen.style.display = 'inline-block';
    } else if (btnEliminarImagen) {
        btnEliminarImagen.style.display = 'none';
    }
    // --- Fin Control de visibilidad inicial ---


    // Mostrar vista previa nueva imagen
    inputFile.addEventListener('change', function () {
        const file = this.files[0];
        if (file && file.type.startsWith('image/')) {
            const reader = new FileReader();
            reader.onload = function (e) {
                previewImg.src = e.target.result;
                imagePreviewWrapper.classList.remove('d-none'); // Mostrar el contenedor de la imagen
                if (btnEliminarImagen) btnEliminarImagen.style.display = 'inline-block';
                eliminarInput.value = '0'; // No marcada para eliminación
            };
            reader.readAsDataURL(file);
        } else {
            // Si el usuario cancela la selección de archivo o selecciona algo que no es imagen
            previewImg.src = ''; // Limpiar la fuente de la imagen
            imagePreviewWrapper.classList.add('d-none'); // Ocultar el contenedor de la imagen
            if (btnEliminarImagen) btnEliminarImagen.style.display = 'none';
            eliminarInput.value = '1'; // Marcar para eliminación (no hay imagen que guardar)
        }
    });

    // Eliminar imagen (botón 'X' único)
    if (btnEliminarImagen) {
        btnEliminarImagen.addEventListener('click', function () {
            previewImg.src = ''; // Limpiar la fuente de la imagen
            imagePreviewWrapper.classList.add('d-none'); // Ocultar el contenedor de la imagen
            inputFile.value = ''; // Limpiar el input de archivo
            eliminarInput.value = '1'; // Marcar para eliminación en el backend
            if (btnEliminarImagen) btnEliminarImagen.style.display = 'none'; // Ocultar el botón 'X'
        });
    }
});
</script>

        <!-- Grupo 7: Observaciones -->
        <fieldset class="border p-2 mb-4">
            <legend class="w-auto px-2 fw-bold text-primary">Observaciones</legend>
            <div class="row">
                <div class="col-md-12">
                    <textarea name="observaciones" id="observaciones" rows="3" class="form-control"><?= esc($medidor['observaciones']) ?></textarea>
                </div>
            </div>
        </fieldset>

        <div class="text-center">
            <button type="submit" class="btn btn-primary px-4">Actualizar</button>
            <a href="<?= base_url('medidores') ?>" class="btn btn-secondary px-4">Cancelar</a>
            
    
        </div>
    </form>
</div>


<?= $this->endSection(); ?>

