<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= $title ?? 'Panel de Control' ?></title>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url('adminlte/plugins/fontawesome-free/css/all.min.css') ?>">
  <!-- AdminLTE core -->
  <link rel="stylesheet" href="<?= base_url('adminlte/css/adminlte.min.css') ?>">
  <!-- Daterangepicker -->
  <link rel="stylesheet" href="<?= base_url('adminlte/plugins/daterangepicker/daterangepicker.css') ?>">
  <!-- Summernote -->
  <link rel="stylesheet" href="<?= base_url('adminlte/plugins/summernote/summernote-bs4.min.css') ?>">

  <!-- Puedes agregar fuentes si deseas -->
  <!-- <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700"> -->
<style>
  /* Asegura que los submenús se desplieguen cuando el padre tiene 'menu-open' */
  .nav-item.menu-open > .nav-treeview {
    display: block !important;
  }

  /* RESALTADO: Solo el texto del enlace final activo (la hoja) */
  .nav-sidebar .nav-link.active { /* Más específico para evitar conflictos */
    color: #16A6BA !important;
    background-color: transparent !important;
  }
  .nav-sidebar .nav-link.active i.nav-icon {
    color: #16A6BA !important;
  }

  /* Resaltado para el enlace padre *solamente si* está desplegado (tiene menu-open) */
  .nav-sidebar .nav-item.menu-open > .nav-link {
    color: #16A6BA !important;
    background-color: transparent !important;
  }
  .nav-sidebar .nav-item.menu-open > .nav-link i.nav-icon {
    color: #16A6BA !important;
  }
  .nav-sidebar .nav-item.menu-open > .nav-link .right.fas.fa-angle-left {
    color: #16A6BA !important;
  }

  /* INDENTACIÓN MARCADA */
  .nav-treeview > .nav-item > .nav-link {
    margin-left: 15px;
  }
  .nav-treeview > .nav-item > .nav-treeview > .nav-item > .nav-link {
    margin-left: 30px;
  }
</style>
</head>

<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">
<div class="wrapper">

  <!-- Encabezado -->
  <?= $this->include('layout/partials/header') ?>

  <!-- Barra lateral -->
  <?= $this->include('layout/partials/sidebar') ?>

  <!-- Contenido principal -->
  <div class="content-wrapper">
    <?= $this->renderSection('content') ?>
  </div>

  <!-- Pie de página -->
  <?= $this->include('layout/partials/footer') ?>
</div>

<!-- Scripts al final para rendimiento -->
<?= $this->include('layout/partials/scripts') ?>

<script>
document.addEventListener("DOMContentLoaded", function () {
  const currentUrl = window.location.href.split(/[?#]/)[0];

  let activeLink = null;
  let bestMatchLength = 0;

  // 1. Buscamos el enlace que MEJOR coincida, no cualquiera.
  // Esto evita que href="#" se active por error.
  document.querySelectorAll(".nav-sidebar a").forEach(link => {
    // Ignoramos enlaces que son solo placeholders y no llevan a ningún sitio.
    if (!link.href || link.getAttribute('href') === '#') {
      return;
    }
    
    const linkHref = link.href.split(/[?#]/)[0];

    // La mejor coincidencia es la URL más larga que sea un prefijo de la URL actual.
    // Esto resuelve el problema de que "/users" active "/users/edit".
    if (currentUrl.startsWith(linkHref) && linkHref.length > bestMatchLength) {
      bestMatchLength = linkHref.length;
      activeLink = link;
    }
  });

  // 2. Si encontramos un enlace que coincide, trabajamos con él.
  if (activeLink) {
    // 3. Aplicamos la clase 'active' ÚNICAMENTE al enlace encontrado.
    activeLink.classList.add('active');

    // 4. Subimos por la jerarquía para ABRIR los menús padres usando 'menu-open'.
    // ¡YA NO APLICAMOS 'active' A LOS PADRES!
    let parent = activeLink.closest('ul.nav-treeview');
    while (parent) {
      const parentLi = parent.closest('li.nav-item');
      if (parentLi) {
        parentLi.classList.add('menu-open');
      }
      parent = parentLi ? parentLi.parentElement.closest('ul.nav-treeview') : null;
    }
  }
});
</script>
</body>
</html>

