<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Estilos generales para botones */
    .btn-back {
        background-color: #6c757d; /* Gris */
        color: white;
        transition: background-color 0.3s ease, color 0.3s ease;
    }
    .btn-back:hover {
        background-color: #5a6268; /* Gris oscuro al pasar el ratón */
        color: white;
    }

    /* Estilos para las etiquetas de detalle */
    .detail-label {
        color: #2d5a86; /* Color azul oscuro */
        font-weight: bold;
        font-size: 0.95rem;
    }
    .detail-value {
        font-size: 1rem;
        margin-bottom: 10px;
        word-wrap: break-word; /* Para manejar descripciones largas */
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Detalles del Grupo
    </h2>

    <div class="card card-primary card-outline">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <p class="detail-label">ID del Grupo:</p>
                    <p class="detail-value"><?= esc($item['id'] ?? 'N/A') ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <p class="detail-label">Nombre del Grupo:</p>
                    <p class="detail-value"><?= esc($item['name'] ?? 'N/A') ?></p>
                </div>
                <div class="col-12 mb-3">
                    <p class="detail-label">Descripción:</p>
                    <p class="detail-value"><?= esc($item['description'] ?? 'N/A') ?></p>
                </div>
            </div>

            <div class="d-flex justify-content-end mt-4">
                <a href="<?= base_url('groups') ?>" class="btn btn-back">
                    <i class="bi bi-arrow-left-circle me-1"></i> Volver a la Lista
                </a>
            </div>
        </div>
    </div>
</div>

</section>
<?= $this->endSection(); ?>