<?php $groups = session('groups') ?? []; ?>

<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Estilos para los botones de acción en la tabla */
    .acciones a {
        color: #2d5a86; /* Color azul oscuro */
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1); /* Fondo azul claro al pasar el ratón */
        color: #16A6BA; /* Color azul cian al pasar el ratón */
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1); /* Fondo rojo claro al pasar el ratón para eliminar */
        color: darkred; /* Color rojo oscuro para eliminar */
    }

    /* Estilos para la cabecera de la tabla */
    thead {
        background-color: #2d5a86; /* Fondo azul oscuro */
        color: white; /* Texto blanco */
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Estilos para las celdas del cuerpo de la tabla */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left; /* Alineación a la izquierda para los botones de acción */
    }

    /* Estilos para los botones de buscar y crear */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86; /* Fondo azul oscuro */
        color: white; /* Texto blanco */
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA; /* Fondo azul cian al pasar el ratón */
        color: white;
    }

    /* Estilos para los inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA; /* Borde azul cian al enfocar */
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5); /* Sombra azul cian */
        outline: none;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Administración de Grupos
    </h2>

    <!-- Formulario de filtros de búsqueda -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('groups') ?>">
        <div class="col-md-4">
            <label class="form-label fw-bold text-sm">ID</label>
            <input type="text" name="id" class="form-control form-control-sm" value="<?= esc($search['id'] ?? '') ?>">
        </div>

        <div class="col-md-4">
            <label class="form-label fw-bold text-sm">Nombre</label>
            <input type="text" name="name" class="form-control form-control-sm" value="<?= esc($search['name'] ?? '') ?>">
        </div>

        <div class="col-md-4">
            <label class="form-label fw-bold text-sm">Descripción</label>
            <input type="text" name="description" class="form-control form-control-sm" value="<?= esc($search['description'] ?? '') ?>">
        </div>

        <!-- Botones de acción para el formulario de búsqueda -->
        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-buscar">
                <i class="bi bi-search me-1"></i> Buscar
            </button>
            <a href="<?= base_url('groups') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-1"></i> Limpiar búsqueda
            </a>
        </div>
    </form>



    <?php if (in_array('admin', $groups)): ?>
    
    <!-- Botón para crear un nuevo grupo -->
    <div class="text-end mb-3">
        <a href="<?= base_url('groups/create') ?>" class="btn btn-crear">
            <i class="bi bi-plus-circle"></i> Nuevo Grupo
        </a>
    </div>
    <?php endif; ?>

    <!-- Tabla de grupos -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Descripción</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('groups/view/' . $item['id']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <?php if (in_array('sigapas_admin', $groups)): ?>
                                <a href="<?= base_url('groups/edit/' . $item['id']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('groups/delete/' . $item['id']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar este registro de grupo?');"><i class="bi bi-trash"></i></a>
                                <?php endif; ?>
                            </td>
                            <td><?= esc($item['id']) ?></td>
                            <td><?= esc($item['name']) ?></td>
                            <td><?= esc($item['description']) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Enlaces de paginación -->
    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

</section>
<?= $this->endSection(); ?>