<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Estilos generales para botones */
    .btn-custom {
        background-color: #2d5a86; /* Color azul oscuro */
        color: white;
        transition: background-color 0.3s ease, color 0.3s ease;
    }
    .btn-custom:hover {
        background-color: #16A6BA; /* Color azul cian al pasar el ratón */
        color: white;
    }
    .btn-cancel {
        background-color: #6c757d; /* Gris */
        color: white;
        transition: background-color 0.3s ease, color 0.3s ease;
    }
    .btn-cancel:hover {
        background-color: #5a6268; /* Gris oscuro al pasar el ratón */
        color: white;
    }

    /* Estilos para inputs al enfocar */
    input.form-control:focus,
    textarea.form-control:focus {
        border: 2px solid #16A6BA; /* Borde azul cian al enfocar */
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5); /* Sombra azul cian */
        outline: none;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Crear Nuevo Grupo
    </h2>

    <div class="card card-primary card-outline">
        <div class="card-body">
            <form action="<?= base_url('groups/store') ?>" method="post">
                <?= csrf_field() ?> <!-- Protección CSRF de CodeIgniter -->

                <div class="mb-3">
                    <label for="name" class="form-label fw-bold text-sm">Nombre del Grupo</label>
                    <input type="text" class="form-control form-control-sm" id="name" name="name" required>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label fw-bold text-sm">Descripción</label>
                    <textarea class="form-control form-control-sm" id="description" name="description" rows="3"></textarea>
                </div>

                <div class="d-flex justify-content-end gap-2 mt-4">
                    <button type="submit" class="btn btn-custom">
                        <i class="bi bi-save me-1"></i> Guardar
                    </button>
                    <a href="<?= base_url('groups') ?>" class="btn btn-cancel">
                        <i class="bi bi-x-circle me-1"></i> Cancelar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

</section>
<?= $this->endSection(); ?>
