<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }

    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }

    .btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
    }

    .btn-secondary:hover {
        background-color: #5a6268;
    }

    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Detalle del Distrito
    </h2>

    <div class="form">
        <fieldset class="border p-3 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Información del Distrito</legend>
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label fw-bold">Codigo Distrito</label>
                    <input type="text" class="form-control form-control-sm" value="<?= esc($dist['codigo']) ?>" readonly>
                </div>
                <div class="col-md-4">
                    <label class="form-label fw-bold">ID Municipio</label>
                    <input type="text" class="form-control form-control-sm" value="<?= esc($dist['id_municipio']) ?>" readonly>
                </div>
                <div class="col-md-4">
                    <label class="form-label fw-bold">Superficie Hectarea</label>
                    <input type="text" class="form-control form-control-sm" value="<?= esc($dist['sup_ha']) ?>" readonly>
                </div>
                <div class="col-md-4">
                    <label class="form-label fw-bold">Distrito</label>
                    <input type="text" class="form-control form-control-sm" value="<?= esc($dist['distrito']) ?>" readonly>
                </div>
            </div>
        </fieldset>

        <div class="text-center mt-4">
            <a href="<?= base_url('distritos') ?>" class="btn btn-sm btn-secondary px-4">Volver</a>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>