<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<section class="content">
    
    <div class="container-fluid">
        
        <div class="row">
            
            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3><?= $redAguaPotable ?></h3>
                        <p>Red Agua Potable</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-tint"></i>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3><?= $redAlcantarillado ?></h3>
                        <p>Red Alcantarillado</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-toilet"></i>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3><?= $medidores ?></h3>
                        <p>Medidores</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-tachometer-alt"></i>
                    </div>
                    
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3><?= $camaras ?></h3>
                        <p>Cámaras</p>
                    </div>
                    <div class="icon">
                    <i class="fas fa-video"></i>
                    </div>
                        <!-- Toggle principal tipo acordeón -->
                        <a class="small-box-footer" data-toggle="collapse" href="#detalleCamaras" role="button">
                            <i class="fas fa-bars"></i> Desglose
                        </a>
                    </div>
                </div>
    
    
                <div class="collapse" id="detalleCamaras">
                    <div class="card card-body">
                    <!-- Distrito -->
                    <a data-toggle="collapse" href="#camarasDistrito" role="button">
                    <i class="fas fa-bars"></i> Por Distrito
                    </a>
                    <ul class="list-group collapse" id="camarasDistrito">
                        <?php foreach ($camarasPorDistrito as $d): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?= $d['nombre'] ?>
                                <span>
                                <?= $d['total'] ?>
                                    <button class="btn btn-sm btn-outline-primary ml-2 verMapa" 
                                    data-tipo="distrito" 
                                    data-nombre="<?= $d['nombre'] ?>">👁️</button>
                                </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <!-- OTB -->
                    <a data-toggle="collapse" href="#camarasOTB" role="button" class="mt-2">
                    <i class="fas fa-bars"></i> Por OTB
                    </a>
                    <ul class="list-group collapse" id="camarasOTB">
                        <?php foreach ($camarasPorOTB as $o): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?= $o['nombre'] ?>
                                <span>
                                    <?= $o['total'] ?>
                                    <button class="btn btn-sm btn-outline-primary ml-2 verMapa" 
                                            data-tipo="otb" 
                                            data-nombre="<?= $o['nombre'] ?>">👁️</button>
                                </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
            
                    <!-- Manzana -->
                    <a data-toggle="collapse" href="#camarasManzana" role="button" class="mt-2">
                        <i class="fas fa-bars"></i> Por Manzana
                    </a>
                    <ul class="list-group collapse" id="camarasManzana" style="max-height:200px; overflow-y:auto;">
                        <?php foreach ($camarasPorManzana as $m): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?= $m['nombre'] ?>
                                <span>
                                    <?= $m['total'] ?>
                                    <button class="btn btn-sm btn-outline-primary ml-2 verMapa" 
                                            data-tipo="manzana" 
                                            data-nombre="<?= $m['nombre'] ?>">👁️</button>
                                </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
            
                    <!-- Predio -->
                    <a data-toggle="collapse" href="#camarasPredio" role="button" class="mt-2">
                        <i class="fas fa-bars"></i> Por Predio
                    </a>
                    <ul class="list-group collapse" id="camarasPredio" style="max-height:200px; overflow-y:auto; width: 100%;">
                        <?php foreach ($camarasPorPredio as $p): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center" style="min-width: 250px;">
                                <?= $p['nombre'] ?>
                                <span>
                                    <?= $p['total'] ?>
                                    <button class="btn btn-sm btn-outline-primary ml-2 verMapa" 
                                            data-tipo="predio" 
                                            data-nombre="<?= $p['nombre'] ?>">👁️</button>
                                </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>


            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3><?= $valvulas ?></h3>
                        <p>Válvulas</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-circle"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
          <div class="col-12 text-center my-4">
            <h1 style="font-size:2rem;font-weight:bold;">SISTEMA GEOINFORMATICO DE AGUA POTABLE Y ALCANTARILLADO SACABA</h1>
          </div>
        </div>
    </div>
</section>

<?php 
/*
<section class="content">
    <div class="container-fluid">
        <div class="row">
      
            <!-- Tarjeta del Mapa General -->
            <div class="col-lg-12 col-12">
            <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Mapa Interactivo de Redes y Componentes</h3>
            </div>
            <div class="card-body" style="height:450px; padding:0;">
                <iframe 
                  src="<?= $mapaUrl ?>" 
                  width="100%" 
                  height="100%" 
                  style="border:none;">
                </iframe>
              </div>
            </div>
            </div>

        </div>
    </div>
</section>
*/
?>
<?php 
/*
<section class="content d-flex justify-content-center align-items-center" style="height: 100vh; margin-top: -340px;">
  <div class="text-center w-100">
    <h1 style="font-size: 2rem; font-weight: bold;">SISTEMA GEOINFORMATICO DE AGUA POTABLE Y ALCANTARILLADO SACABA</h1>
  </div>
</section>
*/
?>

<?= $this->endSection() ?>