<?php $groups = session('groups') ?? []; ?>
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }

    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    .btn-custom {
    background-color: #2E5C87;  /* Azul personalizado */
    color: white;
    border: none;
}

.btn-custom:hover {
    background-color: #244766;  /* Azul más oscuro en hover */
    color: #fff;
}

</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86;">Lista de Conceptos</h2>

    <!-- Formulario de búsqueda -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('conceptos') ?>">
        <div class="col-md-3">
            <label class="form-label fw-bold">Concepto</label>
            <input type="text" name="concepto" class="form-control form-control-sm" value="<?= esc($search['concepto'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">Nombre</label>
            <input type="text" name="nombre" class="form-control form-control-sm" value="<?= esc($search['nombre'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">Tipo</label>
            <input type="text" name="tipoconcepto" class="form-control form-control-sm" value="<?= esc($search['tipoconcepto'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">Clase</label>
            <input type="text" name="clase" class="form-control form-control-sm" value="<?= esc($search['clase'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">Referencia</label>
            <input type="text" name="referencia" class="form-control form-control-sm" value="<?= esc($search['referencia'] ?? '') ?>">
        </div>
        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-custom"><i class="bi bi-search"></i> Buscar</button>
            <a href="<?= base_url('conceptos') ?>" class="btn btn-secondary"><i class="bi bi-x-circle"></i> Limpiar</a>
        </div>
    </form>


    <?php if (in_array('sigapas_admin', $groups)): ?>
    <!-- Botón Crear -->
        <div class="text-end mb-3">
            <a href="<?= base_url('conceptos/create') ?>" class="btn btn-custom"> <i class="bi bi-plus-circle"></i> Nuevo Concepto</a>
        </div>
    <?php endif; ?>



    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>Concepto</th>
                    <th>Nombre</th>
                    <th>Tipo</th>
                    <th>Clase</th>
                    <th>Referencia</th>
                    <th>Desde</th>
                    <th>Hasta</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr><td colspan="8" class="text-center text-muted">No se encontraron resultados.</td></tr>
                <?php else: ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="acciones">
                                <?php if (in_array('sigapas_admin', $groups)): ?>
                                <a href="<?= base_url('conceptos/edit/' . $item['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('conceptos/delete/' . $item['gid']) ?>" class="eliminar" onclick="return confirm('¿Eliminar este registro?');" title="Eliminar"><i class="bi bi-trash"></i></a>
                                <?php endif; ?>
                            </td>
                            <td><?= esc($item['concepto']) ?></td>
                            <td><?= esc($item['nombre']) ?></td>
                            <td><?= esc($item['tipoconcepto']) ?></td>
                            <td><?= esc($item['clase']) ?></td>
                            <td><?= esc($item['referencia']) ?></td>
                            <td><?= esc($item['desde']) ?></td>
                            <td><?= esc($item['hasta']) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection(); ?>
