<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<div class="container mt-4">
    <h2 class="text-center fw-bold mb-4" style="color: #2d5a86;">Editar Concepto</h2>

    <form action="<?= base_url('conceptos/update/' . $item['gid']) ?>" method="post" class="row g-3">

        <div class="col-md-4">
            <label class="form-label fw-bold">Concepto *</label>
            <input type="text" name="concepto" value="<?= esc($item['concepto']) ?>" required class="form-control">
        </div>

        <div class="col-md-4">
            <label class="form-label fw-bold">Tipo de Concepto *</label>
            <input type="text" name="tipoconcepto" value="<?= esc($item['tipoconcepto']) ?>" required class="form-control">
        </div>

        <div class="col-md-4">
            <label class="form-label fw-bold">Nombre</label>
            <input type="text" name="nombre" value="<?= esc($item['nombre']) ?>" class="form-control">
        </div>

        <div class="col-md-6">
            <label class="form-label fw-bold">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="2"><?= esc($item['descripcion']) ?></textarea>
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Desde</label>
            <input type="date" name="desde" value="<?= esc($item['desde']) ?>" class="form-control">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Hasta</label>
            <input type="date" name="hasta" value="<?= esc($item['hasta']) ?>" class="form-control">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Número</label>
            <input type="text" name="numero" value="<?= esc($item['numero']) ?>" class="form-control">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Porcentaje</label>
            <input type="number" step="0.01" name="porcentaje" value="<?= esc($item['porcentaje']) ?>" class="form-control">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Monto</label>
            <input type="number" step="0.01" name="monto" value="<?= esc($item['monto']) ?>" class="form-control">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Rango 1</label>
            <input type="text" name="rango1" value="<?= esc($item['rango1']) ?>" class="form-control">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Rango 2</label>
            <input type="text" name="rango2" value="<?= esc($item['rango2']) ?>" class="form-control">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold">Rango 3</label>
            <input type="text" name="rango3" value="<?= esc($item['rango3']) ?>" class="form-control">
        </div>

        <div class="col-md-4">
            <label class="form-label fw-bold">Referencia</label>
            <input type="text" name="referencia" value="<?= esc($item['referencia']) ?>" class="form-control">
        </div>

        <div class="col-md-4">
            <label class="form-label fw-bold">Clase</label>
            <input type="text" name="clase" value="<?= esc($item['clase']) ?>" class="form-control">
        </div>

        <div class="col-12 d-flex justify-content-end gap-2 mt-4">
            <a href="<?= base_url('conceptos') ?>" class="btn btn-secondary"><i class="bi bi-arrow-left-circle"></i> Cancelar</a>
            <button type="submit" class="btn btn-primary"><i class="bi bi-check-circle"></i> Actualizar</button>
        </div>
    </form>
</div>

<?= $this->endSection(); ?>
