<?php $groups = session('groups') ?? []; ?>

<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* --- Tus estilos originales --- */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }
    .btn-buscar,
    .btn-crear,
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover,
    .btn-importar:hover {
        background-color: #16A6BA;
        color: white;
    }
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
    /* Estilos para los encabezados con ordenamiento */
    .sortable-header {
        cursor: pointer;
        position: relative;
        text-decoration: none;
        color: inherit;
        display: block;
        padding: 5px;
    }
    .sortable-header:hover {
        background-color: rgba(255, 255, 255, 0.2);
    }
    .sort-icon {
        font-size: 0.8rem;
        margin-left: 5px;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Listado de Cámaras
    </h2>

    <!-- Formulario de filtros -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('camaras') ?>">
        <!-- Campos -->
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Código</label>
            <input type="text" name="codigo" class="form-control form-control-sm" value="<?= esc($search['codigo'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Nombre de Calle</label>
            <input type="text" name="nombre_calle" class="form-control form-control-sm" value="<?= esc($search['nombre_calle'] ?? '') ?>">
        </div>
        
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Fecha Instalación Desde</label>
            <input type="text" name="fecha_inicio_in" class="form-control form-control-sm" placeholder="DD-MM-AAAA" value="<?= esc($search['fecha_inicio_in'] ?? '') ?>">
        </div>
            
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Fecha Instalación Hasta</label>
            <input type="text" name="fecha_fin_in" class="form-control form-control-sm" placeholder="DD-MM-AAAA" value="<?= esc($search['fecha_fin_in'] ?? '') ?>">
        </div>
        
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Diámetro</label>
            <input type="text" name="diametro" class="form-control form-control-sm" value="<?= esc($search['diametro'] ?? '') ?>">
        </div>
        
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Fecha Habilitación Desde</label>
            <input type="text" name="fecha_inicio" class="form-control form-control-sm" placeholder="DD-MM-AAAA" value="<?= esc($search['fecha_inicio'] ?? '') ?>">
        </div>
            
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Fecha Habilitación Hasta</label>
            <input type="text" name="fecha_fin" class="form-control form-control-sm" placeholder="DD-MM-AAAA" value="<?= esc($search['fecha_fin'] ?? '') ?>">
        </div>
        
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Distrito</label>
            <input type="text" name="distrito" class="form-control form-control-sm" value="<?= esc($search['distrito'] ?? '') ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-bold text-sm">Gestion</label>
            <input type="text" name="gestion" class="form-control form-control-sm" value="<?= esc($search['gestion'] ?? '') ?>">
        </div>
        <!-- Agrega campos de orden ocultos para mantenerlos en la búsqueda -->
        <input type="hidden" name="order_by" value="<?= esc($orderBy) ?>">
        <input type="hidden" name="order_direction" value="<?= esc($orderDirection) ?>">

        <!-- Botones -->
        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-buscar">
                <i class="bi bi-search me-1"></i> Buscar cámaras
            </button>
            <a href="<?= base_url('camaras') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-1"></i> Limpiar búsqueda
            </a>
        </div>
    </form>
    
    <!-- Botón Crear -->
    
   
          <!-- shapefile -->
        
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
    <?php endif; ?>
    
    
    
    <?php if (in_array('sigapas_tecnico', $groups) and in_array('sigapas_camaras', $groups)): ?>
    <div class="row">
        <div class="col-md-3 mb-4" style="color: #2d5a86">  
            <h5 class="mb-3"><b>Nueva Camara</b>
                
            </h5>
            <form action="<?= site_url('camaras/importarShape') ?>" method="post" enctype="multipart/form-data">
                
                <input type="file" name="shapefile[]" id="shapefile" multiple required class="form-control">
                <small class="form-text text-muted">
                    Puedes seleccionar todos los archivos (.shp, .shx, .dbf, .prj, etc.) a la vez.
                </small>
                
                <div class="text-end mb-3">
                    
                    <button type="submit" class="btn btn-importar"><i class="bi bi-plus-circle"></i> Importar</button>
                
                
                </div>
            </form>
    
        </div>
    </div>
    <?php endif; ?>

    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>
                        <?php
                        // Genera el URL para el ordenamiento de esta columna
                        $newOrderDirection = ($orderBy === 'codigo' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('camaras') . '?' . http_build_query(array_merge($search, ['order_by' => 'codigo', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            Código
                            <?php if ($orderBy === 'codigo'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-alpha-down' : 'bi-sort-alpha-up' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>
                        <?php
                        $newOrderDirection = ($orderBy === 'nombre_calle' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('camaras') . '?' . http_build_query(array_merge($search, ['order_by' => 'nombre_calle', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            Calle
                            <?php if ($orderBy === 'nombre_calle'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-alpha-down' : 'bi-sort-alpha-up' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>
                        <?php
                        $newOrderDirection = ($orderBy === 'fecha_instalacion' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('camaras') . '?' . http_build_query(array_merge($search, ['order_by' => 'fecha_instalacion', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            Fecha Instalación
                            <?php if ($orderBy === 'fecha_instalacion'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-down-alt' : 'bi-sort-down' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>Diámetro</th>
                    <th>Estado</th>
                    <th>Ubicación</th>
                    <th>Forma</th>
                    <th>Fecha Habilitaciónción</th>
                    <th>Distrito</th>
                    <th>OTB</th>
                    <th>Gestion</th>
                    <th>Usuario</th>
                    <th>
                        <?php
                        $newOrderDirection = ($orderBy === 'fecha_usuario' && $orderDirection === 'ASC') ? 'DESC' : 'ASC';
                        $url = base_url('camaras') . '?' . http_build_query(array_merge($search, ['order_by' => 'fecha_usuario', 'order_direction' => $newOrderDirection]));
                        ?>
                        <a href="<?= $url ?>" class="sortable-header">
                            Fecha Usuario
                            <?php if ($orderBy === 'fecha_usuario'): ?>
                                <i class="bi sort-icon <?= $orderDirection === 'ASC' ? 'bi-sort-down-alt' : 'bi-sort-down' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="20" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $cam): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('camaras/view/' . $cam['gid']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <?php if (in_array('sigapas_tecnico', $groups) and in_array('sigapas_camaras', $groups)): ?>
                                <a href="<?= base_url('camaras/edit/' . $cam['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('camaras/delete/' . $cam['gid']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar esta cámara?');"><i class="bi bi-trash"></i></a>
                                <?php endif; ?>
                                <a href="<?= base_url('camaras/ver_camaras_ol/' . $cam['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>
                            </td>
                            <td><?= esc($cam['codigo']) ?></td>
                            <td><?= esc($cam['nombre_calle']) ?></td>
                            <td><?= esc($cam['fecha_instalacion']) ?></td>
                            <td><?= esc($cam['diametro']) ?></td>
                            <td><?= esc($cam['estado']) ?></td>
                            <td><?= esc($cam['ubicacion']) ?></td>
                            <td><?= esc($cam['forma']) ?></td>
                            <td><?= esc($cam['fecha_habilitacion']) ?></td>
                            <td><?= esc($cam['distrito']) ?></td>
                            <td><?= esc($cam['otb']) ?></td>
                            <td><?= esc($cam['gestion']) ?></td>
                            <td><?= esc($cam['usuario']) ?></td>
                            <td><?= date("d-m-Y H:i:s", strtotime($cam['fecha_usuario'])) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection(); ?>







