<?php

namespace App\Models;

use CodeIgniter\Model;

use App\Libraries\Auditoria;

class ValvulasModel extends Model
{
    protected $table = 'bdgeo.valvulas';
    protected $primaryKey = 'gid';
    protected $allowedFields = [
        'geom', 'norte', 'este', 'elevacion',
        'diametro', 'id_valvula', 'tipo', 'funcion', 'edad', 'estado',
        'tapa', 'responsable', 'ubicacion', 'departamento', 'provincia',
        'municipio', 'distrito', 'otb', 'descripcion', 'gestion'
    ];

    public function getFilteredData($limit, $offset, $filters = [], $orderBy = 'cod_fijo', $orderDirection = 'ASC')
    {
        $builder = $this->db->table($this->table);


        if (!empty($filters['id_valvula'])) {
            $builder->where("LOWER(id_valvula) ILIKE '%" . strtolower($filters['id_valvula']) . "%'");
        }
        if (!empty($filters['ubicacion'])) {
            $builder->where("LOWER(ubicacion) ILIKE '%" . strtolower($filters['ubicacion']) . "%'");
        }
        if (!empty($filters['otb'])) {
            $builder->where("LOWER(otb) ILIKE '%" . strtolower($filters['otb']) . "%'");
        }
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }
        if (!empty($filters['gestion'])) {
            $builder->where("LOWER(gestion) ILIKE '%" . strtolower($filters['gestion']) . "%'");
        }
        // --- Lógica de ordenamiento generalizada para manejar NULLs ---
        if (!empty($orderBy)) {
        // La sintaxis 'columna [ASC|DESC] NULLS LAST' es la más confiable en PostgreSQL
        $builder->orderBy("$orderBy $orderDirection NULLS LAST", '', false);
        }
    
        return $builder->get($limit, $offset)->getResultArray();
    
    }

    public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['id_valvula'])) {
            $builder->where("LOWER(id_valvula) ILIKE '%" . strtolower($filters['id_valvula']) . "%'");
        }
        if (!empty($filters['ubicacion'])) {
            $builder->where("LOWER(ubicacion) ILIKE '%" . strtolower($filters['ubicacion']) . "%'");
        }
        if (!empty($filters['otb'])) {
            $builder->where("LOWER(otb) ILIKE '%" . strtolower($filters['otb']) . "%'");
        }
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }

        if (!empty($filters['gestion'])) {
            $builder->where("LOWER(gestion) ILIKE '%" . strtolower($filters['gestion']) . "%'");
        }
        return $builder->countAllResults();
    }
    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    }     
}



