<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class UserModel extends Model
{
    protected $table            = 'admin.users';
    protected $primaryKey       = 'id';
    protected $returnType       = 'array';
    //protected $useTimestamps    = true
    protected $useTimestamps    = false;    
    protected $createdField     = 'created_at';  
 
    protected $allowedFields    = [
        'username',
        'password_hash',
        'email',
        'active',
        'estado',
        'nombre',
        'apellido',
    ];
    
    public function getUserGroups($userId)
    {
        $builder = $this->db->table('admin.user_group');
        $builder->select('group_id');
        $builder->where('user_id', $userId);
        $query = $builder->get();
        return array_column($query->getResultArray(), 'group_id'); 
    }


    public function buscar($filtros)
    {
        foreach ($filtros as $campo => $valor) {
            if (!empty($valor)) {
                $this->like("LOWER($campo)", strtolower($valor));
            }
        }

        return $this;
    }
    
    public function getUserByUsername($username)
    {
        return $this->where('username', $username)->first();
    }

    public function getGroupId($userId)
    {
        $builder = $this->db->table('admin.user_group');
        $builder->select('group_id');
        $builder->where('user_id', $userId);
        $query = $builder->get();
        $result = $query->getRowArray();
        return $result['group_id'] ?? null;
    }

	public function buscarUsuarioMail($email) 
    {
    	$db = db_connect();
        $builder = $db->table($this->table)->where('email',$email)->where('estado', 'A');
    	$resultado = $builder->get();
        return $resultado->getResult() ? $resultado->getResult()[0] : false;
    }

	public function buscarUsuarioUsuario($usuario) 
    {
    	$db = db_connect();
        $builder = $db->table($this->table)->where('username',$usuario)->where('estado', 'A');
    	$resultado = $builder->get();
        return $resultado->getResult() ? $resultado->getResult()[0] : false;
    }
    
  public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor_with_roles($id, $data, $groups = [])
    {
        $db = \Config\Database::connect();
        //$db->transStart(); // 🔹 Iniciamos transacción
        $db->transBegin();
        
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();        
    
        // --- Actualizar datos del auditor ---
        $this->update($id, $data);
        
        // --- Actualizar roles ---
        $builder = $db->table('admin.user_group');
    
        // Eliminar roles actuales
        $builder->where('user_id', $id)->delete();
    
        // Insertar nuevos roles si hay
        if (!empty($groups)) {
            foreach ($groups as $groupId) {
                $builder->insert([
                    'user_id'  => $id,
                    'group_id' => $groupId
                ]);
            }
        }
    
        //$db->transComplete(); // 🔹 Cerramos transacción
        $db->transCommit();
    
        return $db->transStatus(); // true = éxito, false = error
    }
    
    public function createDbRole($userId)
    {
        $db = \Config\Database::connect();
        
        $user = $this->find($userId);
    
        if (!$user) {
            return "Usuario no encontrado";
        }
    
        //$groups = session('groups');
    
        //if (in_array('sigapas_tecnico', $groups)) {
            $username = $user['username'];
            $encrypter = \Config\Services::encrypter();
            $password = $encrypter->decrypt(hex2bin($user['password_hash']));
    
            $sqlCreate = "DO $$
            BEGIN
                IF NOT EXISTS (SELECT FROM pg_catalog.pg_roles WHERE rolname = :username:) THEN
                    EXECUTE format('CREATE ROLE %I LOGIN PASSWORD %L', :username:, :password:);
                END IF;
            END
            $$;";
    
            $db->query($sqlCreate, [
                'username' => $username,
                'password' => $password
            ]);
    
            $userGroupModel = new \App\Models\UserGroupModel();

            // Traer los grupos con join para obtener el nombre
            $builder = $userGroupModel->select('groups.name')
                ->join('admin.groups', 'groups.id = user_group.group_id')
                ->where('user_group.user_id', $userId);
            
            $groups = $builder->findAll();
            
            foreach ($groups as $g) {
                $roleName = $g['name']; // el nombre del grupo se usará como rol
                $sqlGrant = "GRANT \"" . $roleName . "\" TO \"" . $username . "\";";
                $db->query($sqlGrant);
            }


            /*
            $userGroupModel = new \App\Models\UserGroupModel();
            $groups = $userGroupModel->where('user_id', $userId)->findAll();
    
            foreach ($groups as $g) {
                $sqlGrant = "GRANT \"" . $g['group_id'] . "\" TO \"" . $username . "\";";
                $db->query($sqlGrant);
            }
            */
    
        //}

        return "Usuario de PostgreSQL creado y roles asignados";
    
    }
    
}



