<?php

namespace App\Models;

use CodeIgniter\Model;

use App\Libraries\Auditoria;

class TransaccionesModel extends Model
{
    protected $table            = 'bdgeo.transacciones';
    protected $primaryKey       = 'id';
    protected $returnType       = 'array';
    protected $useTimestamps    = false;

    protected $allowedFields    = [
        'tipo',
        'clase',        
        'esquema',
        'descripcion',
        'fecha_i',
        'usuario_i',
        'fecha_u',
        'usuario_u',
        'estado',
    ];

    public function buscar($filtros)
    {
        foreach ($filtros as $campo => $valor) {
            if (!empty($valor)) {
                if ($campo === 'id') {
                    $this->where($campo, (int)$valor);
                } else {
                    $this->like("LOWER($campo)", strtolower($valor));
                }
            }
        }
        return $this;
    }

    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
    
    public function ejecutar_transaccion($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();        
        $query = $db->query("SELECT bdgeo.f_actualizar_red_agua_potable(?) AS resultado", [$id]);
        $row = $query->getRow();
        $db->transCommit();
        return $row && $row->resultado ? true : false;
    }
        
    // Nueva función: ejecutar sanlo.f_revertir_transaccion(id)
    public function revertir($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();        
        $query = $db->query("SELECT bdgeo.f_revertir_transaccion(?) AS resultado", [$id]);
        $row = $query->getRow();
        $db->transCommit();
        return $row && $row->resultado ? true : false;
    }
}
