<?php

namespace App\Models;

use CodeIgniter\Model;

use App\Libraries\Auditoria;

class Red_agua_potableModel extends Model
{
    protected $table             = 'bdgeo.red_agua_potable';
    protected $primaryKey        = 'gid';
    protected $returnType        = 'array';
    protected $useTimestamps     = false;

    protected $allowedFields     = [
        'id_tuberia',
        'gestion',
        'diametro',
        'longitud',
        'material',
        'funcion_tuberia',
        'tipo_tuberia',
        'profundidad',
        'estado_actual',
        'calle',
        'ubicacion',
        'dist_de_la_red',
        'otb',
        'distrito',
        'municipio',
        'provincia',
        'departamento',
        'responsable',
        'observaciones',
        'usuario',
        'fecha_usuario'
    ];

    /**
     * Obtiene datos filtrados y ordenados con limit y offset
     * @param int $limit El número de registros a obtener.
     * @param int $offset El punto de inicio para la consulta.
     * @param array $filters Un array asociativo con los campos de búsqueda.
     * @param string $orderBy El campo por el cual ordenar.
     * @param string $orderDirection La dirección de la ordenación ('ASC' o 'DESC').
     * @return array Los registros filtrados y paginados.
     */
    public function getFilteredData($limit, $offset, $filters = [], $orderBy = 'id_tuberia', $orderDirection = 'ASC')
    {
        $builder = $this->db->table($this->table);

        // Aplica filtros de búsqueda
        if (!empty($filters['id_tuberia'])) {
            $builder->where("LOWER(CAST(id_tuberia AS TEXT)) ILIKE '%" . strtolower($filters['id_tuberia']) . "%'");
        }
        if (!empty($filters['gestion'])) {
            $builder->where("LOWER(CAST(gestion AS TEXT)) ILIKE '%" . strtolower($filters['gestion']) . "%'");
        }
        
        if(!empty($filters['diametro'])) {
            $builder->where("LOWER(CAST(diametro AS TEXT)) ILIKE '%" . strtolower($filters['diametro']) . "%'");
        }
        if (!empty($filters['longitud'])) {
            $builder->where("LOWER(CAST(longitud AS TEXT)) ILIKE '%" . strtolower($filters['longitud']) . "%'");
        }
        if (!empty($filters['material'])) {
            $builder->where("LOWER(material) ILIKE '%" . strtolower($filters['material']) . "%'");
        }
        if (!empty($filters['funcion_tuberia'])) {
            $builder->where("LOWER(funcion_tuberia) ILIKE '%" . strtolower($filters['funcion_tuberia']) . "%'");
        }
        if (!empty($filters['tipo_tuberia'])) {
            $builder->where("LOWER(tipo_tuberia) ILIKE '%" . strtolower($filters['tipo_tuberia']) . "%'");
        }
        if (!empty($filters['profundidad'])) {
            $builder->where("LOWER(CAST(profundidad AS TEXT)) ILIKE '%" . strtolower($filters['profundidad']) . "%'");
        }
        if (!empty($filters['estado_actual'])) {
            $builder->where("LOWER(estado_actual) ILIKE '%" . strtolower($filters['estado_actual']) . "%'");
        }
        if (!empty($filters['calle'])) {
            $builder->where("LOWER(calle) ILIKE '%" . strtolower($filters['calle']) . "%'");
        }
        if (!empty($filters['ubicacion'])) {
            $builder->where("LOWER(ubicacion) ILIKE '%" . strtolower($filters['ubicacion']) . "%'");
        }
        if (!empty($filters['dist_de_la_red'])) {
            $builder->where("LOWER(CAST(dist_de_la_red AS TEXT)) ILIKE '%" . strtolower($filters['dist_de_la_red']) . "%'");
        }
        if (!empty($filters['otb'])) {
            $builder->where("LOWER(otb) ILIKE '%" . strtolower($filters['otb']) . "%'");
        }
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(CAST(distrito AS TEXT)) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }
        if (!empty($filters['municipio'])) {
            $builder->where("LOWER(municipio) ILIKE '%" . strtolower($filters['municipio']) . "%'");
        }
        if (!empty($filters['provincia'])) {
            $builder->where("LOWER(provincia) ILIKE '%" . strtolower($filters['provincia']) . "%'");
        }
        if (!empty($filters['departamento'])) {
            $builder->where("LOWER(departamento) ILIKE '%" . strtolower($filters['departamento']) . "%'");
        }
        if (!empty($filters['responsable'])) {
            $builder->where("LOWER(responsable) ILIKE '%" . strtolower($filters['responsable']) . "%'");
        }
        if (!empty($filters['observaciones'])) {
            $builder->where("LOWER(observaciones) ILIKE '%" . strtolower($filters['observaciones']) . "%'");
        }
        
        // --- Lógica de ordenamiento generalizada para manejar NULLs ---
        if (!empty($orderBy)) {
        // La sintaxis 'columna [ASC|DESC] NULLS LAST' es la más confiable en PostgreSQL
        $builder->orderBy("$orderBy $orderDirection NULLS LAST", '', false);
        }
    
        return $builder->get($limit, $offset)->getResultArray();
    }

    /**
     * Cuenta el número total de registros filtrados.
     * @param array $filters Un array asociativo con los campos de búsqueda.
     * @return int El número total de registros.
     */
    public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        // Aplica los mismos filtros de búsqueda que en getFilteredData
        if (!empty($filters['id_tuberia'])) {
            $builder->where("LOWER(CAST(id_tuberia AS TEXT)) ILIKE '%" . strtolower($filters['id_tuberia']) . "%'");
        }
        if (!empty($filters['gestion'])) {
            $builder->where("LOWER(CAST(gestion AS TEXT)) ILIKE '%" . strtolower($filters['gestion']) . "%'");
        }
        
        if (!empty($filters['diametro'])) {
            $builder->where("LOWER(CAST(diametro AS TEXT)) ILIKE '%" . strtolower($filters['diametro']) . "%'");
        }
        if (!empty($filters['longitud'])) {
            $builder->where("LOWER(CAST(longitud AS TEXT)) ILIKE '%" . strtolower($filters['longitud']) . "%'");
        }
        if (!empty($filters['material'])) {
            $builder->where("LOWER(material) ILIKE '%" . strtolower($filters['material']) . "%'");
        }
        if (!empty($filters['funcion_tuberia'])) {
            $builder->where("LOWER(funcion_tuberia) ILIKE '%" . strtolower($filters['funcion_tuberia']) . "%'");
        }
        if (!empty($filters['tipo_tuberia'])) {
            $builder->where("LOWER(tipo_tuberia) ILIKE '%" . strtolower($filters['tipo_tuberia']) . "%'");
        }
        if (!empty($filters['profundidad'])) {
            $builder->where("LOWER(CAST(profundidad AS TEXT)) ILIKE '%" . strtolower($filters['profundidad']) . "%'");
        }
        if (!empty($filters['estado_actual'])) {
            $builder->where("LOWER(estado_actual) ILIKE '%" . strtolower($filters['estado_actual']) . "%'");
        }
        if (!empty($filters['calle'])) {
            $builder->where("LOWER(calle) ILIKE '%" . strtolower($filters['calle']) . "%'");
        }
        if (!empty($filters['ubicacion'])) {
            $builder->where("LOWER(ubicacion) ILIKE '%" . strtolower($filters['ubicacion']) . "%'");
        }
        if (!empty($filters['dist_de_la_red'])) {
            $builder->where("LOWER(CAST(dist_de_la_red AS TEXT)) ILIKE '%" . strtolower($filters['dist_de_la_red']) . "%'");
        }
        if (!empty($filters['otb'])) {
            $builder->where("LOWER(otb) ILIKE '%" . strtolower($filters['otb']) . "%'");
        }
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(CAST(distrito AS TEXT)) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }
        if (!empty($filters['municipio'])) {
            $builder->where("LOWER(municipio) ILIKE '%" . strtolower($filters['municipio']) . "%'");
        }
        if (!empty($filters['provincia'])) {
            $builder->where("LOWER(provincia) ILIKE '%" . strtolower($filters['provincia']) . "%'");
        }
        if (!empty($filters['departamento'])) {
            $builder->where("LOWER(departamento) ILIKE '%" . strtolower($filters['departamento']) . "%'");
        }
        if (!empty($filters['responsable'])) {
            $builder->where("LOWER(responsable) ILIKE '%" . strtolower($filters['responsable']) . "%'");
        }
        if (!empty($filters['observaciones'])) {
            $builder->where("LOWER(observaciones) ILIKE '%" . strtolower($filters['observaciones']) . "%'");
        }

        return $builder->countAllResults();
    }

    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
        
}
