<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class OTBModel extends Model
{
    protected $table         = 'bdgeo.otbs';
    protected $primaryKey    = 'gid';
    protected $returnType    = 'array';
    protected $useTimestamps = false;

    protected $allowedFields = [
    'id_otb',
    'nombres_otb',
    'distritos',
    ];

    /**
     * Aplica filtros personalizados y retorna QueryBuilder para usar paginación manual
     */
public function getFilteredData(?int $limit = null, int $offset = 0, array $filters = [])
{
    $builder = $this->db->table($this->table);

    foreach ($filters as $campo => $valor) {
        if (!empty($valor) && in_array($campo, $this->allowedFields)) {
            if ($campo === 'id_otb') {
                // Para sup_area (campo numérico), aplicar comparación exacta o rango
                if (is_numeric($valor)) {
                    $builder->where($campo, (float)$valor);
                }
            } else {
                // Para campos texto usar ILIKE con LOWER
                $builder->where("LOWER($campo) ILIKE '%" . strtolower($valor) . "%'");
            }
        }
    }

    $builder->orderBy('gid', 'ASC');

    if ($limit !== null) {
        return $builder->get($limit, $offset);
    }

    return $builder->get();
}
     public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['id_otb'])) {
        if (is_numeric($filters['id_otb'])) {
            $builder->where('id_otb', (float) $filters['id_otb']);
        }
    }
        if (!empty($filters['nombres_otb'])) {
            $builder->where("LOWER(nombres_otb) ILIKE '%" . strtolower($filters['nombres_otb']) . "%'");
        }
        if (!empty($filters['distritos'])) {
            $builder->where("LOWER(distritos) ILIKE '%" . strtolower($filters['distritos']) . "%'");
        }
    
        return $builder->countAllResults();
    }
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    }     
}
