<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class MedidoresModel extends Model
{
    protected $table = 'bdgeo.medidores';
    protected $primaryKey = 'gid';
    protected $allowedFields = [
        'cod_fijo', 'cod_usuario', 'nombres', 'apellidos', 'direccion', 'num_casa', 'nit_ci', 'tipo_vivienda', 'categoria', 'numero_medidor', 'marca_medidor', 'diam_acometida', 'mat_tub_acometida',
        'ubicacion', 'distrito', 'otb', 'zona_abast', 'zona_cod_comercial', 'lectura_inicial', 'fecha_lect_inicial',
        'lectura_final', 'fecha_lect_final', 'inst_con_liberacion', 'usu_funcionario', 'gestion',
        'fecha_instalacion', 'estado_registro', 'tipo_lectura', 'control_datos_crc',
        'observaciones', 'foto_inicial', 'este', 'norte', 'cota', 'municipio', 'provincia', 'departamento'
    
    ];


    // ✔ Devuelve los datos filtrados con orden por gid


    /**
     * Obtiene datos filtrados, paginados y ordenados.
     * @param int $limit El número de registros a obtener.
     * @param int $offset El punto de inicio para la consulta.
     * @param array $filters Un array asociativo con los campos de búsqueda.
     * @param string $orderBy El campo por el cual ordenar.
     * @param string $orderDirection La dirección de la ordenación ('ASC' o 'DESC').
     * @return array Los registros filtrados y paginados.
     */
    public function getFilteredData($limit, $offset, $filters = [], $orderBy = 'cod_fijo', $orderDirection = 'ASC')
    {
        $builder = $this->db->table($this->table);

        // Aplica filtros de búsqueda para cada campo
        if (!empty($filters['cod_fijo'])) {
            $builder->where("LOWER(CAST(cod_fijo AS TEXT)) ILIKE '%" . strtolower($filters['cod_fijo']) . "%'");
        }
        if (!empty($filters['cod_usuario'])) {
            $builder->where("LOWER(CAST(cod_usuario AS TEXT)) ILIKE '%" . strtolower($filters['cod_usuario']) . "%'");
        }
        if (!empty($filters['nombres'])) {
            $builder->where("LOWER(nombres) ILIKE '%" . strtolower($filters['nombres']) . "%'");
        }
        if (!empty($filters['apellidos'])) {
            $builder->where("LOWER(apellidos) ILIKE '%" . strtolower($filters['apellidos']) . "%'");
        }
        if (!empty($filters['direccion'])) {
            $builder->where("LOWER(direccion) ILIKE '%" . strtolower($filters['direccion']) . "%'");
        }
        if (!empty($filters['nit_ci'])) {
            $builder->where("LOWER(CAST(nit_ci AS TEXT)) ILIKE '%" . strtolower($filters['nit_ci']) . "%'");
        }
        if (!empty($filters['numero_medidor'])) {
            $builder->where("LOWER(CAST(numero_medidor AS TEXT)) ILIKE '%" . strtolower($filters['numero_medidor']) . "%'");
        }
        
        // --- Lógica de ordenamiento generalizada para manejar NULLs ---
        if (!empty($orderBy)) {
        // La sintaxis 'columna [ASC|DESC] NULLS LAST' es la más confiable en PostgreSQL
        $builder->orderBy("$orderBy $orderDirection NULLS LAST", '', false);
        }
    
        return $builder->get($limit, $offset)->getResultArray();
    }

    /**
     * Cuenta el número total de registros filtrados.
     * @param array $filters Un array asociativo con los campos de búsqueda.
     * @return int El número total de registros.
     */
    public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        // Aplica los mismos filtros de búsqueda que en getFilteredData
        if (!empty($filters['cod_fijo'])) {
            $builder->where("LOWER(CAST(cod_fijo AS TEXT)) ILIKE '%" . strtolower($filters['cod_fijo']) . "%'");
        }
        if (!empty($filters['cod_usuario'])) {
            $builder->where("LOWER(CAST(cod_usuario AS TEXT)) ILIKE '%" . strtolower($filters['cod_usuario']) . "%'");
        }
        if (!empty($filters['nombres'])) {
            $builder->where("LOWER(nombres) ILIKE '%" . strtolower($filters['nombres']) . "%'");
        }
        if (!empty($filters['apellidos'])) {
            $builder->where("LOWER(apellidos) ILIKE '%" . strtolower($filters['apellidos']) . "%'");
        }
        if (!empty($filters['direccion'])) {
            $builder->where("LOWER(direccion) ILIKE '%" . strtolower($filters['direccion']) . "%'");
        }
        if (!empty($filters['nit_ci'])) {
            $builder->where("LOWER(CAST(nit_ci AS TEXT)) ILIKE '%" . strtolower($filters['nit_ci']) . "%'");
        }
        if (!empty($filters['numero_medidor'])) {
            $builder->where("LOWER(CAST(numero_medidor AS TEXT)) ILIKE '%" . strtolower($filters['numero_medidor']) . "%'");
        }

        return $builder->countAllResults();
    }

    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 

}
