<?php namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class CamarasModel extends Model
{
    protected $table = 'bdgeo.camaras';
    protected $primaryKey = 'gid';
    protected $allowedFields = [
        'codigo', 'nombre_calle', 'numero_cruce', 'este', 'norte', 'cota', 'fecha_instalacion',
        'tipo_inversion', 'nom_proyecto', 'emp_responsable', 'supervisor', 'encargado_lev',
        'resp_catastro', 'diametro', 'altura', 'estado', 'ubicacion', 'forma',
        'material_tapa', 'caida', 'nom_cuenca', 'valor_instalacion', 'cod_activos_fijos',
        'fecha_habilitacion', 'distrito', 'otb', 'observaciones', 'gestion','usuario', 'fecha_usuario'
    ];


    public function getFilteredData($limit, $offset, $filters = [], $orderBy = 'cod_fijo', $orderDirection = 'ASC')
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['codigo'])) {
            $builder->where("LOWER(codigo) ILIKE '%" . strtolower($filters['codigo']) . "%'");
        }
        if (!empty($filters['nombre_calle'])) {
            $builder->where("LOWER(nombre_calle) ILIKE '%" . strtolower($filters['nombre_calle']) . "%'");
        }

        if (!empty($filters['fecha_instalacion'])) {
            $builder->where("TO_CHAR(fecha_instalacion, 'YYYY-MM-DD') ILIKE '%" . strtolower($filters['fecha_instalacion']) . "%'");
        }
        
        if (!empty($filters['diametro'])) {
            $builder->where("LOWER(diametro) ILIKE '%" . strtolower($filters['diametro']) . "%'");
        }

        if (!empty($filters['fecha_inicio_in'])) {
        $dtInicio = \DateTime::createFromFormat('d-m-Y', $filters['fecha_inicio_in']);
            if ($dtInicio !== false) {
            $builder->where('fecha_instalacion >=', $dtInicio->format('Y-m-d'));
            }
        }

        if (!empty($filters['fecha_fin_in'])) {
        $dtFin = \DateTime::createFromFormat('d-m-Y', $filters['fecha_fin_in']);
            if ($dtFin !== false) {
            $builder->where('fecha_instalacion <=', $dtFin->format('Y-m-d'));
            }
        }

        if (!empty($filters['fecha_fin'])) {
        $dtFin = \DateTime::createFromFormat('d-m-Y', $filters['fecha_fin']);
            if ($dtFin !== false) {
            $builder->where('fecha_habilitacion <=', $dtFin->format('Y-m-d'));
         }
        }
        
        
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }
        
        if (!empty($filters['gestion'])) {
            $builder->where("LOWER(gestion) ILIKE '%" . strtolower($filters['gestion']) . "%'");
        }

         // --- Lógica de ordenamiento generalizada para manejar NULLs ---
        if (!empty($orderBy)) {
        // La sintaxis 'columna [ASC|DESC] NULLS LAST' es la más confiable en PostgreSQL
        $builder->orderBy("$orderBy $orderDirection NULLS LAST", '', false);
        }
    
        return $builder->get($limit, $offset)->getResultArray();
    }

    public function getFilteredCount($filters = [])
    {
        $builder = $this->db->table($this->table);

        if (!empty($filters['codigo'])) {
            $builder->where("LOWER(codigo) ILIKE '%" . strtolower($filters['codigo']) . "%'");
        }
        if (!empty($filters['nombre_calle'])) {
            $builder->where("LOWER(nombre_calle) ILIKE '%" . strtolower($filters['nombre_calle']) . "%'");
        }
       
       if (!empty($filters['fecha_inicio_in'])) {
        $dtInicio = \DateTime::createFromFormat('d-m-Y', $filters['fecha_inicio_in']);
            if ($dtInicio !== false) {
            $builder->where('fecha_instalacion >=', $dtInicio->format('Y-m-d'));
            }
        }

        if (!empty($filters['fecha_fin_in'])) {
        $dtFin = \DateTime::createFromFormat('d-m-Y', $filters['fecha_fin_in']);
            if ($dtFin !== false) {
            $builder->where('fecha_instalacion <=', $dtFin->format('Y-m-d'));
            }
        }
       
       
        if (!empty($filters['diametro'])) {
            $builder->where("LOWER(diametro) ILIKE '%" . strtolower($filters['diametro']) . "%'");
        }

        if (!empty($filters['fecha_inicio'])) {
        $dtInicio = \DateTime::createFromFormat('d-m-Y', $filters['fecha_inicio']);
            if ($dtInicio !== false) {
            $builder->where('fecha_habilitacion >=', $dtInicio->format('Y-m-d'));
            }
        }

        if (!empty($filters['fecha_fin'])) {
        $dtFin = \DateTime::createFromFormat('d-m-Y', $filters['fecha_fin']);
            if ($dtFin !== false) {
            $builder->where('fecha_habilitacion <=', $dtFin->format('Y-m-d'));
            }
        }

        
        if (!empty($filters['distrito'])) {
            $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
        }
        
        if (!empty($filters['gestion'])) {
            $builder->where("LOWER(gestion) ILIKE '%" . strtolower($filters['gestion']) . "%'");
        }

        return $builder->countAllResults();
    }
    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    }     
}

