<?php

namespace App\Controllers;

use App\Models\ValvulasModel;

class Valvulas extends BaseController
{
    protected $ValvulasModel; // <- propiedad para el modelo

    public function __construct()
    {
        $this->ValvulasModel = new ValvulasModel();
    }

    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $search = $this->request->getGet();
        $orderBy = $this->request->getGet('order_by') ?? 'fecha_usuario';
        $orderDirection = $this->request->getGet('order_direction') ?? 'DESC';

        $perPage = 10;
        $currentPage = (int) ($this->request->getVar('page') ?? 1);
        $offset = ($currentPage - 1) * $perPage;

        // CORREGIDO: Usar la propiedad de modelo correcta ($this->ValvulasModel)
        $totalItems = $this->ValvulasModel->getFilteredCount($search);
        $items = $this->ValvulasModel->getFilteredData($perPage, $offset, $search, $orderBy, $orderDirection);
        
        // Se prepara el paginador
        $pager = service('pager');
        $pager->makeLinks($currentPage, $perPage, $totalItems);

        $data = [
            'items' => $items,
            'pager' => $pager,
            'search' => $search,
            'orderBy' => $orderBy,
            'orderDirection' => $orderDirection,
        ];

        return view('valvulas/index', $data);
    }
    
    public function importarShape()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         

    helper(['filesystem', 'form']);

    // 1. Validar que se recibieron archivos
    $uploadedFiles = $this->request->getFileMultiple('shapefile');
    if (!$uploadedFiles || count($uploadedFiles) === 0 || !$uploadedFiles[0]->isValid()) {
        return redirect()->back()->with('error', 'No se subió ningún archivo o los archivos son inválidos.');
    }

    // 2. Crear un directorio temporal único
    $tempDir = WRITEPATH . 'uploads/shapetmp_' . uniqid();
    if (!mkdir($tempDir, 0777, true)) {
        return redirect()->back()->with('error', 'No se pudo crear el directorio temporal.');
    }

    // 3. Mover los archivos subidos al directorio temporal
    $allowedExtensions = ['shp', 'shx', 'dbf', 'prj', 'cpg', 'sbn', 'sbx'];
    foreach ($uploadedFiles as $file) {
        if ($file->isValid() && !$file->hasMoved()) {
            $ext = strtolower($file->getClientExtension());
            if (in_array($ext, $allowedExtensions)) {
                $file->move($tempDir, $file->getClientName());
            }
        }
    }

    // 4. Encontrar el archivo .shp principal
    $shpFiles = glob($tempDir . '/*.shp');
    if (empty($shpFiles)) {
        delete_files($tempDir, true);
        rmdir($tempDir);
        return redirect()->back()->with('error', 'Carga incompleta. No se encontró el archivo .shp principal.');
    }
    $shpFile = $shpFiles[0];

    // 5. Armar y ejecutar el comando ogr2ogr
    
    // LÍNEA CORREGIDA: Obtenemos la configuración directamente
    $dbConfig = config('Database')->default; 

    $pg_conn = sprintf(
        "PG:host=%s port=%s dbname=%s user=%s password=%s",
        $dbConfig['hostname'],
        $dbConfig['port'] ?? '5432',
        $dbConfig['database'],
        $dbConfig['username'],
        $dbConfig['password']
    );

    $cmd = sprintf(
    "ogr2ogr -f PostgreSQL %s %s -nln bdgeo.valvulas -append -nlt POINT -lco GEOMETRY_NAME=geom",
        escapeshellarg($pg_conn),
        escapeshellarg($shpFile)
    );

    exec($cmd . ' 2>&1', $output, $exitCode);

    // 6. Borrar la carpeta temporal y su contenido
    delete_files($tempDir, true);
    rmdir($tempDir);

    // 7. Redirigir con mensaje de éxito o error
    if ($exitCode !== 0) {
        $errorMessage = 'Error al importar el Shapefile: ' . implode("\n", $output);
        return redirect()->back()->with('error', $errorMessage);
    }

    return redirect()->to(site_url('valvulas'))->with('success', 'Shapefile importado exitosamente.');
}

    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        return view('valvulas/create');
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $emptyToNull = fn($v) => trim($v) === '' ? null : $v;

        $data = [
            'id_valvula'    => $this->request->getPost('id_valvula'),
            'este'          => $emptyToNull($this->request->getPost('este')),
            'norte'         => $emptyToNull($this->request->getPost('norte')),
            'cota'          => $emptyToNull($this->request->getPost('cota')),
            'diametro'      => $emptyToNull($this->request->getPost('diametro')),
            'tipo'          => $this->request->getPost('tipo'),
            'funcion'       => $this->request->getPost('funcion'),
            'edad'          => $emptyToNull($this->request->getPost('edad')),
            'estado'        => $this->request->getPost('estado'),
            'tapa'          => $this->request->getPost('tapa'),
            'responsable'   => $this->request->getPost('responsable'),
            'ubicacion'     => $this->request->getPost('ubicacion'),
            'departamento'  => $this->request->getPost('departamento'),
            'provincia'     => $this->request->getPost('provincia'),
            'municipio'     => $this->request->getPost('municipio'),
            'distrito'      => $this->request->getPost('distrito'),
            'otb'           => $this->request->getPost('otb'),
            'descripcion'   => $this->request->getPost('descripcion'),
            'gestion'       => $this->request->getPost('gestion'),
        ];

        $this->ValvulasModel->insert_auditor($data);

        return redirect()->to(base_url('valvulas'))->with('mensaje', 'Válvula registrada exitosamente.');
    }

    public function edit($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $valvula = $this->ValvulasModel->find($id);

        if (!$valvula) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException("Válvula no encontrada: $id");
        }
            $db = \Config\Database::connect();
            $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'TIPO_VALVULA' ORDER BY nombre");
            $tipoValvula = $query->getResultArray();
            $db = \Config\Database::connect();
            $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'FUNCION_VALVULA' ORDER BY nombre");
            $funcionValvula = $query->getResultArray();
            $db = \Config\Database::connect();
            $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'ESTADO_VALVULA' ORDER BY nombre");
            $estadoValvula = $query->getResultArray();
            $db = \Config\Database::connect();
            $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'TAPA_VALVULA' ORDER BY nombre");
            $tapaValvula = $query->getResultArray();
            // Normalización de campos select (¡aquí está la solución!)
    $valvula['tipo'] = $this->mapearNombreAConcepto($valvula['tipo'], $tipoValvula);
    $valvula['funcion'] = $this->mapearNombreAConcepto($valvula['funcion'], $funcionValvula);
    $valvula['estado'] = $this->mapearNombreAConcepto($valvula['estado'], $estadoValvula);
    $valvula['tapa'] = $this->mapearNombreAConcepto($valvula['tapa'], $tapaValvula);

        return view('valvulas/edit', [
            'valvula' => $valvula,
            'tipoValvula' => $tipoValvula,
            'funcionValvula' => $funcionValvula,
            'estadoValvula' => $estadoValvula,
            'tapaValvula' => $tapaValvula
            ]);
    }

    public function update($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();

        $camposEnteros = ['este', 'norte', 'cota', 'diametro', 'edad'];
        foreach ($camposEnteros as $campo) {
            if (isset($data[$campo]) && $data[$campo] === '') {
                $data[$campo] = null;
            } elseif (isset($data[$campo])) {
                $data[$campo] = (int) $data[$campo];
            }
        }

        $this->ValvulasModel->update_auditor($id, $data);
        return redirect()->to('/valvulas');
    }

    public function view($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $valvula = $this->ValvulasModel->find($id);

        if (!$valvula) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Válvula no encontrada");
        }

        return view('valvulas/view', ['valvula' => $valvula]);
    }

    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $this->ValvulasModel->delete_auditor($id);
        return redirect()->to('/valvulas')->with('status', 'Registro eliminado correctamente');
    }
    
    public function ver_valvulas_ol ($gid) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        // se debe crear la variable de session para guardar el url del servidor grafico
        $i_jameuge = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=valvulas_gid";
        $i_jameuge = $i_jameuge . "&gid=" . $gid;
        $i_jameuge = $i_jameuge . "&ip_host=server1.jmap4.com";
        //redirect($i_jameuge);
        //return redirect()->to('https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid&gid=1&ip_host=server1.jmap4.com');
        return redirect()->to($i_jameuge);
    }
    private function mapearNombreAConcepto($valor, $listaOpciones) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }              
        foreach ($listaOpciones as $opcion) {
        if (strcasecmp(trim($opcion['nombre']), trim($valor)) === 0) {
            return $opcion['concepto'];
        }
    }
    return $valor; // devuelve el mismo valor si no se encuentra mapeo
}
}


