<?php

namespace App\Controllers;

use App\Models\UserModel;

class Users extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new UserModel();
    }

    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $filtros = [
            'username' => $this->request->getGet('username'),
            'email'    => $this->request->getGet('email'),
            'nombre'   => $this->request->getGet('nombre'),
            'apellido' => $this->request->getGet('apellido'),
            'estado'   => $this->request->getGet('estado'),
        ];

        $porPagina = 10;

        $data['items'] = $this->model
            ->buscar($filtros)
            ->orderBy('id', 'ASC')
            ->paginate($porPagina);

        $data['pager'] = $this->model->pager;
        $data['search'] = $filtros;

        return view('users/index', $data);
    }

    public function view($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);

        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Usuario no encontrado");
        }

        return view('users/view', ['item' => $item]);
    }

    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        return view('users/create');
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();
        //$data['password_hash'] = password_hash($data['password_hash'], PASSWORD_DEFAULT);
        $encrypter = \Config\Services::encrypter();
    	$data['password_hash'] = bin2hex($encrypter->encrypt($data['password_hash']));        

        $this->model->insert_auditor($data);
        
        
        //$msg = $this->model->createDbRole($id);   
    
        //return redirect()->to('/users')->with('mensaje', 'Usuario creado correctamente '.$msg);
        return redirect()->to('/users')->with('mensaje', 'Usuario creado correctamente ');
    }

    public function edit($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);
        
        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Usuario no encontrado");
        }

        $groupModel = new \App\Models\GroupModel();

        // todos los grupos
        $groups = $groupModel->findAll();

        // roles actuales del usuario
        $userGroups = $this->model->getUserGroups($id); 

        return view('users/edit', [
            'item'       => $item,
            'groups'     => $groups,
            'userGroups' => $userGroups
        ]);
        //return view('users/edit', ['item' => $item]);
    }

    public function update_bk($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();

        if (!empty($data['password_hash'])) {
            //$data['password_hash'] = password_hash($data['password_hash'], PASSWORD_DEFAULT);
            $encrypter = \Config\Services::encrypter();
    	    $data['password_hash'] = bin2hex($encrypter->encrypt($data['password_hash']));

        } else {
            unset($data['password_hash']);
        }

       // Asegurar que active sea 0 o 1
       $data['active'] = isset($data['active']) ? (int)$data['active'] : 0;
    
        foreach ($data as $key => $value) {
            //$data[$key] = (trim($value) === '') ? null : $value;
            if (is_string($value)) {
                $value = trim($value);
                $data[$key] = ($value === '') ? null : $value;
            } else {
                // si no es string, lo dejamos tal cual
                $data[$key] = $value;
            }        

        }

        //$this->model->update_auditor($id, $data);
        /* 
        $id = $this->request->getPost('id');
        $data = [
            'nombre' => $this->request->getPost('nombre'),
            'estado' => $this->request->getPost('estado'),
            // otros campos...
        ];
        */
        
        $groups = $this->request->getPost('groups') ?? [];
        
        if ($this->model->update_auditor_with_roles($id, $data, $groups)) {
            $msg = $this->model->createDbRole($id);            
            //return redirect()->to('/auditores')->with('mensaje', 'Auditor actualizado correctamente');
            return redirect()->to(base_url('users'))->with('mensaje', 'Usuario actualizado correctamente');
        } else {
            return redirect()->back()->with('error', 'Ocurrió un error al actualizar el auditor');
        }

        //return redirect()->to(base_url('users'))->with('mensaje', 'Usuario actualizado correctamente');
    }

    public function update($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
        $data = $this->request->getPost();
    
        // --- Manejo de password ---
        if (!empty($data['password_hash'])) {
            $encrypter = \Config\Services::encrypter();
            $data['password_hash'] = bin2hex($encrypter->encrypt($data['password_hash']));
        } else {
            unset($data['password_hash']);
        }
    
        // --- Active como 0/1 ---
        $data['active'] = isset($data['active']) ? (int)$data['active'] : 0;
    
        // --- Limpiar strings vacíos ---
        foreach ($data as $key => $value) {
            if (is_string($value)) {
                $value = trim($value);
                $data[$key] = ($value === '') ? null : $value;
            } else {
                $data[$key] = $value;
            }
        }
    
        // --- Filtrar solo los campos permitidos ---
        $allowed = $this->model->allowedFields;
        $data = array_intersect_key($data, array_flip($allowed));
    
        // --- Roles seleccionados ---
        $groups = $this->request->getPost('groups') ?? [];
    
        // --- Actualizar ---
        if ($this->model->update_auditor_with_roles($id, $data, $groups)) {
            //$userModel = new \App\Models\UserModel();
            $msg = $this->model->createDbRole($id);            
            return redirect()->to(base_url('users'))
                             ->with('mensaje', 'Usuario actualizado correctamente');
        } else {
            return redirect()->back()
                             ->with('error', 'Ocurrió un error al actualizar el usuario');
        }
    }


    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $this->model->delete_auditor($id);
        
            //$msg = $this->Model->createDbRole($id);            

        return redirect()->to(base_url('users'))->with('status', 'Usuario eliminado correctamente');
    }
    
    

    
}


