<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\TransaccionesModel;
use App\Libraries\Auditoria;
use CodeIgniter\Database\Exceptions\DatabaseException;

class Transacciones extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new TransaccionesModel();
    }

    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $filtros = [
            'id'          => $this->request->getGet('id'),
            'tipo'        => $this->request->getGet('tipo'),
            'clase'       => $this->request->getGet('clase'),
            'esquema'     => $this->request->getGet('esquema'),
            'descripcion' => $this->request->getGet('descripcion'),
            'usuario_i'   => $this->request->getGet('usuario_i'),
            'estado'      => $this->request->getGet('estado'),
        ];

        $porPagina = 10;

        $data['items'] = $this->model
            ->buscar($filtros)
            ->orderBy('id', 'ASC')
            ->paginate($porPagina);

        $data['pager'] = $this->model->pager;
        $data['search'] = $filtros;

        return view('transacciones/index', $data);
    }
    
    public function edit($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);

        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }

        return view('transacciones/edit', ['item' => $item]);
    }

    
    public function view($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);

        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }

        return view('transacciones/view', ['item' => $item]);
    }

    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        return view('transacciones/create');
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();

        try {
            $this->model->insert_auditor($data);
            return redirect()->back()->with('status', 'Se inserto la transacción!');
        } catch (DatabaseException $e) {
            $db->transRollback();
            log_message('error', 'Error al insertar: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Error al insertar la transacción');
        }

        return redirect()->to('/transacciones')->with('mensaje', 'Registro creado correctamente');
    }

    public function update($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = [
            'tipo'        => $this->request->getPost('tipo'),
            'clase'       => $this->request->getPost('clase'),
            'esquema'     => $this->request->getPost('esquema'),
            'descripcion' => $this->request->getPost('descripcion'),
            'fecha_i'     => $this->request->getPost('fecha_i'),
            'usuario_i'   => $this->request->getPost('usuario_i'),
            'fecha_u'     => $this->request->getPost('fecha_u'),
            'usuario_u'   => $this->request->getPost('usuario_u'),
            'estado'      => $this->request->getPost('estado'),
        ];

        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }
        
        try {
            $this->model->update_auditor($id, $data);
            return redirect()->back()->with('status', 'Modificación realizada!');
        } catch (DatabaseException $e) {
            return redirect()->back()->with('error', 'Error al modificar la transacción');
        }
        //return redirect()->to('/transacciones')->with('status', 'Registro actualizado correctamente');
    }

    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        try {
            $this->model->delete_auditor($id);
            return redirect()->back()->with('status', 'Se elimino la transacción!');
        } catch (DatabaseException $e) {
            $db->transRollback();
            log_message('error', 'Error al eliminar: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Error al ejecutar la transacción');
        }
        //return redirect()->to('/transacciones')->with('status', 'Transacción eliminada correctamente');
    }

    public function ejecutar_transaccion_no_sirve($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $db = \Config\Database::connect();
        $transacciones = new TransaccionesModel($db);
        $auditoria = new Auditoria($db);

        try {
            $db->transBegin();

            // Auditoría del backend PID
            $auditoria->actualizar_backend_pid();

            // Llamada a la función almacenada
            $query = $db->query("SELECT bdgeo.f_actualizacion_catastral(?) AS resultado", [$id]);
            $row = $query->getRow();

            if ($row && $row->resultado) {
                $db->transCommit();
                return redirect()->back()->with('status', 'Transacción ejecutada correctamente');
            } else {
                $db->transRollback();
                return redirect()->back()->with('error', 'La función no retornó un resultado válido');
            }

        } catch (DatabaseException $e) {
            $db->transRollback();
            log_message('error', 'Error al ejecutar transacción: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Error al ejecutar la transacción');
        }
    }
  
    public function revertir_no_sirve($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $db = \Config\Database::connect();
        $auditoria = new Auditoria($db);

        try {
            $db->transBegin();

            $auditoria->actualizar_backend_pid();

            $query = $db->query("SELECT bdgeo.f_revertir_transaccion(?) AS resultado", [$id]);
            $row = $query->getRow();

            if ($row && $row->resultado) {
                $db->transCommit();
                return redirect()->back()->with('status', 'Transacción revertida correctamente');
            } else {
                $db->transRollback();
                return redirect()->back()->with('error', 'No se pudo revertir la transacción');
            }

        } catch (DatabaseException $e) {
            $db->transRollback();
            log_message('error', 'Error al revertir transacción: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Error al revertir la transacción');
        }
    }
  
    //Formato con uso de la capa model
    public function ejecutar_transaccion($id) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);
        
        if ($item) {
            if ($item['estado'] == 'PROCESADA') {
                return redirect()->to('/transacciones/view/'.$id)->with('status', 'La transacción ya fue procesada');
            } elseif ($item['estado'] == 'ACTIVA') {
                $this->model->ejecutar_transaccion($id);
                $item = $this->model->find($id);
                return view('transacciones/view', ['item' => $item]);
            } else {
                return redirect()->to('/transacciones/view/'.$id)->with('error', 'Estado del registro erroneo!!!');
            }
        } else {
            return redirect()->to('/transacciones/view/'.$id)->with('error', 'Registro no encontrado!!!');
        }
    }
    
    //Formato con uso de la capa model
    public function revertir($id) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $this->model->revertir($id);
        $item = $this->model->find($id);
        if (!$item) {
            return redirect()->to('/transacciones/view/'.$id)->with('error', 'Registro no encontrado!!!');
        }
        return view('transacciones/view', ['item' => $item]);        
    } 
    
}

