<?php

namespace App\Controllers;

use App\Models\Red_alcantarilladoModel;

class Red_alcantarillado extends BaseController
{
    protected $model;

    public function __construct()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }        
        $this->model = new Red_alcantarilladoModel();
    }

    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        
        $search = $this->request->getGet();
        $orderBy = $this->request->getGet('order_by') ?? 'fecha_usuario';
        $orderDirection = $this->request->getGet('order_direction') ?? 'DESC';

        $perPage = 10;
        $currentPage = (int) ($this->request->getVar('page') ?? 1);
        $offset = ($currentPage - 1) * $perPage;

        // CORREGIDO: Usar la propiedad de modelo correcta ($this->model)
        $totalItems = $this->model->getFilteredCount($search);
        $items = $this->model->getFilteredData($perPage, $offset, $search, $orderBy, $orderDirection);
        
        // Se prepara el paginador
        $pager = service('pager');
        $pager->makeLinks($currentPage, $perPage, $totalItems);

        $data = [
            'items' => $items,
            'pager' => $pager,
            'search' => $search,
            'orderBy' => $orderBy,
            'orderDirection' => $orderDirection,
        ];

        return view('red_alcantarillado/index', $data);
    }

    
    public function importarShape()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
    helper(['filesystem', 'form']);

    // 1. Validar que se recibieron archivos
    $uploadedFiles = $this->request->getFileMultiple('shapefile');
    if (!$uploadedFiles || count($uploadedFiles) === 0 || !$uploadedFiles[0]->isValid()) {
        return redirect()->back()->with('error', 'No se subió ningún archivo o los archivos son inválidos.');
    }

    // 2. Crear un directorio temporal único
    $tempDir = WRITEPATH . 'uploads/shapetmp_' . uniqid();
    if (!mkdir($tempDir, 0777, true)) {
        return redirect()->back()->with('error', 'No se pudo crear el directorio temporal.');
    }

    // 3. Mover los archivos subidos al directorio temporal
    $allowedExtensions = ['shp', 'shx', 'dbf', 'prj', 'cpg', 'sbn', 'sbx'];
    foreach ($uploadedFiles as $file) {
        if ($file->isValid() && !$file->hasMoved()) {
            $ext = strtolower($file->getClientExtension());
            if (in_array($ext, $allowedExtensions)) {
                $file->move($tempDir, $file->getClientName());
            }
        }
    }

    // 4. Encontrar el archivo .shp principal
    $shpFiles = glob($tempDir . '/*.shp');
    if (empty($shpFiles)) {
        delete_files($tempDir, true);
        rmdir($tempDir);
        return redirect()->back()->with('error', 'Carga incompleta. No se encontró el archivo .shp principal.');
    }
    $shpFile = $shpFiles[0];

    // 5. Armar y ejecutar el comando ogr2ogr
    
    // LÍNEA CORREGIDA: Obtenemos la configuración directamente
    $dbConfig = config('Database')->default; 

    $pg_conn = sprintf(
        "PG:host=%s port=%s dbname=%s user=%s password=%s",
        $dbConfig['hostname'],
        $dbConfig['port'] ?? '5432',
        $dbConfig['database'],
        $dbConfig['username'],
        $dbConfig['password']
    );

    $cmd = sprintf(
    "ogr2ogr -f PostgreSQL %s %s -nln bdgeo.red_alcantarillado -append -nlt MULTILINESTRING -lco GEOMETRY_NAME=geom",
        escapeshellarg($pg_conn),
        escapeshellarg($shpFile)
    );

    exec($cmd . ' 2>&1', $output, $exitCode);

    // 6. Borrar la carpeta temporal y su contenido
    delete_files($tempDir, true);
    rmdir($tempDir);

    // 7. Redirigir con mensaje de éxito o error
    if ($exitCode !== 0) {
        $errorMessage = 'Error al importar el Shapefile: ' . implode("\n", $output);
        return redirect()->back()->with('error', $errorMessage);
    }

    return redirect()->to(site_url('red_alcantarillado'))->with('success', 'Shapefile importado exitosamente.');
}

    public function view($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);

        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }

        return view('red_alcantarillado/view', ['item' => $item]);
    }

    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        return view('red_alcantarillado/create');
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();

        // Limpia campos vacíos opcionales (los convierte en null)
        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }

        $this->model->insert_auditor($data);

        return redirect()->to('/red_alcantarillado')->with('mensaje', 'Registro creado correctamente');
    }

    public function edit($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);

        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }
            $db = \Config\Database::connect();
            $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'ESTADO_ACTUAL' ORDER BY nombre");
            $estadoActual = $query->getResultArray();
            $db = \Config\Database::connect();
            $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'TIPO_FUNCION_TUBERIA' ORDER BY nombre");
            $tipoTuberia = $query->getResultArray();
            // Normalización de campos select (¡aquí está la solución!)
            $item['estado_actual'] = $this->mapearNombreAConcepto($item['estado_actual'], $estadoActual);
            $item['tipo_tuberia'] = $this->mapearNombreAConcepto($item['tipo_tuberia'], $tipoTuberia);
            
            return view('red_alcantarillado/edit', [
            'item' => $item,
            'estadoActual' => $estadoActual,
            'tipoTuberia' => $tipoTuberia
        ]);
    }

    public function update($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $request = \Config\Services::request();

        $data = [
            'id_tuberia'       => $request->getPost('id_tuberia'),
            'gestion'          => $request->getPost('gestion'),
            'diametro'         => $request->getPost('diametro'),
            'pendiente'        => $request->getPost('pendiente'),
            'calle'            => $request->getPost('calle'),
            'estado_actual'    => $request->getPost('estado_actual'),
            'responsable'      => $request->getPost('responsable'),
            'longitud'         => $request->getPost('longitud'),
            'material'         => $request->getPost('material'),
            'tipo_tuberia'     => $request->getPost('tipo_tuberia'),
            'ubicacion'        => $request->getPost('ubicacion'),
            'profundidad'      => $request->getPost('profundidad'),
            'departamento'     => $request->getPost('departamento'),
            'provincia'        => $request->getPost('provincia'),
            'municipio'        => $request->getPost('municipio'),
            'distrito'         => $request->getPost('distrito'),
            'otb'              => $request->getPost('otb'),
            'observaciones'    => $request->getPost('observaciones'),
        ];

        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }

        $this->model->update_auditor($id, $data);

        return redirect()->to(base_url('red_alcantarillado'))->with('mensaje', 'Registro actualizado correctamente');
    }

    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        $this->model->delete_auditor($id);

        return redirect()->to(base_url('red_alcantarillado'))->with('mensaje', 'Registro eliminado correctamente');
    }

    
    public function ver_red_alcantarillado_ol ($gid) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        // se debe crear la variable de session para guardar el url del servidor grafico
        $i_jameuge = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=red_alcantarillado_gid";
        $i_jameuge = $i_jameuge . "&gid=" . $gid;
        $i_jameuge = $i_jameuge . "&ip_host=server1.jmap4.com";
        //redirect($i_jameuge);
        //return redirect()->to('https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid&gid=1&ip_host=server1.jmap4.com');
        return redirect()->to($i_jameuge);
    }   
    private function mapearNombreAConcepto($valor, $listaOpciones) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
        foreach ($listaOpciones as $opcion) {
        if (strcasecmp(trim($opcion['nombre']), trim($valor)) === 0) {
            return $opcion['concepto'];
        }
    }
    return $valor; // devuelve el mismo valor si no se encuentra mapeo
}
}

