<?php

namespace App\Controllers;
use App\Models\PredioModel;

class Predios extends BaseController
{
    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new PredioModel();
        $search = $this->request->getGet();

        $data = [
            'items'  => $model->getFilteredData($search, 10),
            'pager'  => $model->pager,
            'search' => $search,
        ];

        return view('predios/index', $data);
    }
    
    public function importarShape()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
    helper(['filesystem', 'form']);

    // 1. Validar que se recibieron archivos
    $uploadedFiles = $this->request->getFileMultiple('shapefile');
    if (!$uploadedFiles || count($uploadedFiles) === 0 || !$uploadedFiles[0]->isValid()) {
        return redirect()->back()->with('error', 'No se subió ningún archivo o los archivos son inválidos.');
    }

    // 2. Crear un directorio temporal único
    $tempDir = WRITEPATH . 'uploads/shapetmp_' . uniqid();
    if (!mkdir($tempDir, 0777, true)) {
        return redirect()->back()->with('error', 'No se pudo crear el directorio temporal.');
    }

    // 3. Mover los archivos subidos al directorio temporal
    $allowedExtensions = ['shp', 'shx', 'dbf', 'prj', 'cpg', 'sbn', 'sbx'];
    foreach ($uploadedFiles as $file) {
        if ($file->isValid() && !$file->hasMoved()) {
            $ext = strtolower($file->getClientExtension());
            if (in_array($ext, $allowedExtensions)) {
                $file->move($tempDir, $file->getClientName());
            }
        }
    }

    // 4. Encontrar el archivo .shp principal
    $shpFiles = glob($tempDir . '/*.shp');
    if (empty($shpFiles)) {
        delete_files($tempDir, true);
        rmdir($tempDir);
        return redirect()->back()->with('error', 'Carga incompleta. No se encontró el archivo .shp principal.');
    }
    $shpFile = $shpFiles[0];

    // 5. Armar y ejecutar el comando ogr2ogr
    
    // LÍNEA CORREGIDA: Obtenemos la configuración directamente
    $dbConfig = config('Database')->default; 

    $pg_conn = sprintf(
        "PG:host=%s port=%s dbname=%s user=%s password=%s",
        $dbConfig['hostname'],
        $dbConfig['port'] ?? '5432',
        $dbConfig['database'],
        $dbConfig['username'],
        $dbConfig['password']
    );

    $cmd = sprintf(
    "ogr2ogr -f PostgreSQL %s %s -nln bdgeo.predios -append -nlt MULTIPOLYGON -lco GEOMETRY_NAME=geom",
        escapeshellarg($pg_conn),
        escapeshellarg($shpFile)
    );

    exec($cmd . ' 2>&1', $output, $exitCode);

    // 6. Borrar la carpeta temporal y su contenido
    delete_files($tempDir, true);
    rmdir($tempDir);

    // 7. Redirigir con mensaje de éxito o error
    if ($exitCode !== 0) {
        $errorMessage = 'Error al importar el Shapefile: ' . implode("\n", $output);
        return redirect()->back()->with('error', $errorMessage);
    }

    return redirect()->to(site_url('predios'))->with('success', 'Shapefile importado exitosamente.');
}


    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        return view('predios/create');
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new PredioModel();

        $data = $this->request->getPost();

        $model->insert_auditor($data);

        return redirect()->to(base_url('predios'))->with('mensaje', 'Predio creado exitosamente.');
    }

    public function edit($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new PredioModel();
        $predio = $model->find($id);

        if (!$predio) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException("Predio no encontrado con ID $id");
        }

        return view('predios/edit', ['predio' => $predio]);
    }

    public function update($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new PredioModel();
        $data = $this->request->getPost();

        $model->update_auditor($id, $data);

        return redirect()->to(base_url('predios'))->with('mensaje', 'Predio actualizado exitosamente.');
    }

    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new PredioModel();
        $model->delete_auditor($id);

        return redirect()->to(base_url('predios'))->with('mensaje', 'Predio eliminado correctamente.');
    }

    public function view($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new PredioModel();
        $predio = $model->find($id);
    
        if (!$predio) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Predio no encontrado");
        }
    
        return view('predios/view', ['predio' => $predio]);
    }


    
    public function verpredio_ol ($gid) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        // se debe crear la variable de session para guardar el url del servidor grafico
        $i_jameuge = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid";
        $i_jameuge = $i_jameuge . "&gid=" . $gid;
        $i_jameuge = $i_jameuge . "&ip_host=server1.jmap4.com";
        //redirect($i_jameuge);
        //return redirect()->to('https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid&gid=1&ip_host=server1.jmap4.com');
        return redirect()->to($i_jameuge);
    }
    
    
}
