<?php

namespace App\Controllers;

use App\Models\OtbModel;

class Otbs extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new OtbModel();
    }

public function index()
{
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
        $model = $this->model;
    
        $search = $this->request->getGet(); // filtros desde URL
        $page = (int) ($this->request->getVar('page') ?? 1);
        $perPage = 10;
        $offset = ($page - 1) * $perPage;
    
        // contar y filtrar
        $total = $model->getFilteredCount($search);
        $items = $model->getFilteredData($perPage, $offset, $search)->getResultArray();
    
        // generar paginador
        $pager = \Config\Services::pager();
        $pager->makeLinks($page, $perPage, $total);
    
        return view('otbs/index', [
            'items' => $items,
            'search' => $search,
            'pager' => $pager,
            'page' => $page,
            'perPage' => $perPage,
            'total' => $total,
        ]);
    }
    
    public function importarShape()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
    helper(['filesystem', 'form']);

    // 1. Validar que se recibieron archivos
    $uploadedFiles = $this->request->getFileMultiple('shapefile');
    if (!$uploadedFiles || count($uploadedFiles) === 0 || !$uploadedFiles[0]->isValid()) {
        return redirect()->back()->with('error', 'No se subió ningún archivo o los archivos son inválidos.');
    }

    // 2. Crear un directorio temporal único
    $tempDir = WRITEPATH . 'uploads/shapetmp_' . uniqid();
    if (!mkdir($tempDir, 0777, true)) {
        return redirect()->back()->with('error', 'No se pudo crear el directorio temporal.');
    }

    // 3. Mover los archivos subidos al directorio temporal
    $allowedExtensions = ['shp', 'shx', 'dbf', 'prj', 'cpg', 'sbn', 'sbx'];
    foreach ($uploadedFiles as $file) {
        if ($file->isValid() && !$file->hasMoved()) {
            $ext = strtolower($file->getClientExtension());
            if (in_array($ext, $allowedExtensions)) {
                $file->move($tempDir, $file->getClientName());
            }
        }
    }

    // 4. Encontrar el archivo .shp principal
    $shpFiles = glob($tempDir . '/*.shp');
    if (empty($shpFiles)) {
        delete_files($tempDir, true);
        rmdir($tempDir);
        return redirect()->back()->with('error', 'Carga incompleta. No se encontró el archivo .shp principal.');
    }
    $shpFile = $shpFiles[0];

    // 5. Armar y ejecutar el comando ogr2ogr
    
    // LÍNEA CORREGIDA: Obtenemos la configuración directamente
    $dbConfig = config('Database')->default; 

    $pg_conn = sprintf(
        "PG:host=%s port=%s dbname=%s user=%s password=%s",
        $dbConfig['hostname'],
        $dbConfig['port'] ?? '5432',
        $dbConfig['database'],
        $dbConfig['username'],
        $dbConfig['password']
    );

    $cmd = sprintf(
    "ogr2ogr -f PostgreSQL %s %s -nln bdgeo.otbs -append -nlt MULTIPOLYGON -lco GEOMETRY_NAME=geom",
        escapeshellarg($pg_conn),
        escapeshellarg($shpFile)
    );

    exec($cmd . ' 2>&1', $output, $exitCode);

    // 6. Borrar la carpeta temporal y su contenido
    delete_files($tempDir, true);
    rmdir($tempDir);

    // 7. Redirigir con mensaje de éxito o error
    if ($exitCode !== 0) {
        $errorMessage = 'Error al importar el Shapefile: ' . implode("\n", $output);
        return redirect()->back()->with('error', $errorMessage);
    }

    return redirect()->to(site_url('otbs'))->with('success', 'Shapefile importado exitosamente.');
}

    public function view($id)
    {
        $otb = $this->model->find($id);
        if (!$otb) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }

        return view('otbs/view', ['otb' => $otb]);
    }

    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $db = \Config\Database::connect();
    $query = $db->query("SELECT DISTINCT distritos FROM bdgeo.otbs WHERE distritos IS NOT NULL AND distritos <> '' ORDER BY distritos");
    $distritos = $query->getResultArray();
    
        return view('otbs/create', [
            'distritos' => $distritos
            ]);
    }


    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = [
            'id_otb'       => $this->request->getPost('id_otb'),
            'nombres_otb'  => $this->request->getPost('nombres_otb'),
            'distritos'    => $this->request->getPost('distritos')
        ];
    
        $this->model->insert_auditor($data);
    
        return redirect()->to('/otbs')->with('mensaje', 'Registro creado correctamente');
    }


    public function edit($gid)

    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
            $otb = $this->model->find($gid);
    
            if (!$otb) {
                throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
            }
            
        $db = \Config\Database::connect();
    $query = $db->query("SELECT DISTINCT distritos FROM bdgeo.otbs WHERE distritos IS NOT NULL AND distritos <> '' ORDER BY distritos");
    $distritos = $query->getResultArray();

        return view('otbs/edit', [
            'otb' => $otb,
            'distritos' => $distritos
        ]);
    }
    


    public function delete($gid)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new \App\Models\OtbModel();
    
        $otb = $model->find($gid);
    
        if (!$otb) {
            return redirect()->to(base_url('otbs'))->with('error', 'Registro no encontrado.');
        }
    
        $success = $model->delete_auditor($gid);
    
        if ($success) {
            return redirect()->to(base_url('otbs'))->with('status', 'Registro OTB eliminado correctamente.');
        } else {
            return redirect()->to(base_url('otbs'))->with('error', 'No se pudo eliminar el registro.');
        }
    }




    public function update($gid)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $id_otb = $this->request->getPost('id_otb');

        $data = [
        'id_otb'   => (is_numeric($id_otb) && $id_otb !== '') ? (float)$id_otb : null,
        'nombres_otb' => $this->request->getPost('nombres_otb'),
        'distritos'   => $this->request->getPost('distritos')
        ];


        $this->model->update_auditor($gid, $data);

        return redirect()->to('/otbs')->with('mensaje', 'OTB actualizada correctamente.');
    }
    public function ver_otbs_ol ($gid) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        // se debe crear la variable de session para guardar el url del servidor grafico
        $i_jameuge = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=otbs_gid";
        $i_jameuge = $i_jameuge . "&gid=" . $gid;
        $i_jameuge = $i_jameuge . "&ip_host=server1.jmap4.com";
        //redirect($i_jameuge);
        //return redirect()->to('https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid&gid=1&ip_host=server1.jmap4.com');
        return redirect()->to($i_jameuge);
    }
    
}
