<?php

namespace App\Controllers;

use App\Models\MedidoresModel;

class Medidores extends BaseController
{
    protected $model;

    public function __construct()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }        
        $this->model = new MedidoresModel();
    }

    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $search = $this->request->getGet();
        $orderBy = $this->request->getGet('order_by') ?? 'cod_fijo';
        $orderDirection = $this->request->getGet('order_direction') ?? 'ASC';

        $perPage = 10;
        $currentPage = (int) ($this->request->getVar('page') ?? 1);
        $offset = ($currentPage - 1) * $perPage;

        // CORREGIDO: Usar la propiedad de modelo correcta ($this->model)
        $totalItems = $this->model->getFilteredCount($search);
        $items = $this->model->getFilteredData($perPage, $offset, $search, $orderBy, $orderDirection);
        
        // Se prepara el paginador
        $pager = service('pager');
        $pager->makeLinks($currentPage, $perPage, $totalItems);

        $data = [
            'items' => $items,
            'pager' => $pager,
            'search' => $search,
            'orderBy' => $orderBy,
            'orderDirection' => $orderDirection,
        ];

        return view('medidores/index', $data);
    }

    
    public function importarShape()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
    helper(['filesystem', 'form']);

    // 1. Validar que se recibieron archivos
    $uploadedFiles = $this->request->getFileMultiple('shapefile');
    if (!$uploadedFiles || count($uploadedFiles) === 0 || !$uploadedFiles[0]->isValid()) {
        return redirect()->back()->with('error', 'No se subió ningún archivo o los archivos son inválidos.');
    }

    // 2. Crear un directorio temporal único
    $tempDir = WRITEPATH . 'uploads/shapetmp_' . uniqid();
    if (!mkdir($tempDir, 0777, true)) {
        return redirect()->back()->with('error', 'No se pudo crear el directorio temporal.');
    }

    // 3. Mover los archivos subidos al directorio temporal
    $allowedExtensions = ['shp', 'shx', 'dbf', 'prj', 'cpg', 'sbn', 'sbx'];
    foreach ($uploadedFiles as $file) {
        if ($file->isValid() && !$file->hasMoved()) {
            $ext = strtolower($file->getClientExtension());
            if (in_array($ext, $allowedExtensions)) {
                $file->move($tempDir, $file->getClientName());
            }
        }
    }

    // 4. Encontrar el archivo .shp principal
    $shpFiles = glob($tempDir . '/*.shp');
    if (empty($shpFiles)) {
        delete_files($tempDir, true);
        rmdir($tempDir);
        return redirect()->back()->with('error', 'Carga incompleta. No se encontró el archivo .shp principal.');
    }
    $shpFile = $shpFiles[0];

    // 5. Armar y ejecutar el comando ogr2ogr
    
    // LÍNEA CORREGIDA: Obtenemos la configuración directamente
    $dbConfig = config('Database')->default; 

    $pg_conn = sprintf(
        "PG:host=%s port=%s dbname=%s user=%s password=%s",
        $dbConfig['hostname'],
        $dbConfig['port'] ?? '5432',
        $dbConfig['database'],
        $dbConfig['username'],
        $dbConfig['password']
    );

    $cmd = sprintf(
    "ogr2ogr -f PostgreSQL %s %s -nln bdgeo.medidores -append -nlt POINT -lco GEOMETRY_NAME=geom",
        escapeshellarg($pg_conn),
        escapeshellarg($shpFile)
    );

    exec($cmd . ' 2>&1', $output, $exitCode);

    // 6. Borrar la carpeta temporal y su contenido
    delete_files($tempDir, true);
    rmdir($tempDir);

    // 7. Redirigir con mensaje de éxito o error
    if ($exitCode !== 0) {
        $errorMessage = 'Error al importar el Shapefile: ' . implode("\n", $output);
        return redirect()->back()->with('error', $errorMessage);
    }

    return redirect()->to(site_url('medidores'))->with('success', 'Shapefile importado exitosamente.');
}


    public function view($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $medidor = $this->model->find($id);
    
        if (!$medidor) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Medidor no encontrado");
        }
    
        return view('medidores/view', ['medidor' => $medidor]);
    }

    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $db = \Config\Database::connect();
        $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'TIPO_VIVIENDA' ORDER BY nombre");
        $tipoVivienda = $query->getResultArray();
        
        $db = \Config\Database::connect();
        $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'CATEGORIA' ORDER BY nombre");
        $categoria = $query->getResultArray();   
        
        $db = \Config\Database::connect();
        $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'UBICACION' ORDER BY nombre");
        $ubicacionOpciones = $query->getResultArray(); 
        
        $db = \Config\Database::connect();
        $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'SI_NO' ORDER BY nombre");
        $instLiberacion = $query->getResultArray(); 

        $db = \Config\Database::connect();
        $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'USUARIO_FUNCIONARIO' ORDER BY nombre");
        $usuarioFuncionario = $query->getResultArray(); 
        
        $db = \Config\Database::connect();
        $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'ESTADO_REGISTRO' ORDER BY nombre");
        $estadoRegistro = $query->getResultArray();
        
        $db = \Config\Database::connect();
        $query = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'TIPO_LECTURA' ORDER BY nombre");
        $tipoLectura = $query->getResultArray();

        return view('medidores/create', [
            'tipoVivienda' => $tipoVivienda,
            'categoria' => $categoria,
            'ubicacionOpciones' => $ubicacionOpciones,
            'instLiberacion' => $instLiberacion,
            'usuarioFuncionario' => $usuarioFuncionario,
            'estadoRegistro' => $estadoRegistro,
            'tipoLectura' => $tipoLectura
        
        ]);        
        
       // return view('medidores/create');
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();
        
        // Limpiar vacíos como null (especialmente fechas)
        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }
        // Procesar la imagen (si se subió)
    $foto = $this->request->getFile('foto_inicial');
    if ($foto && $foto->isValid() && !$foto->hasMoved()) {
        $nombreUnico = $foto->getRandomName();
        $foto->move(FCPATH . 'uploads/fotos', $nombreUnico);
        $data['foto_inicial'] = $nombreUnico;
    }
        $this->model->insert_auditor($data);

        return redirect()->to('/medidores')->with('mensaje', 'Registro creado correctamente');
    
    }

     public function edit($id)
        {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }                 
            $medidor = $this->model->find($id);
    
            if (!$medidor) {
                throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
            }
            
                $db = \Config\Database::connect();

    $tipoVivienda = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'TIPO_VIVIENDA' ORDER BY nombre")->getResultArray();
    $categoria = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'CATEGORIA' ORDER BY nombre")->getResultArray();
    $ubicacionOpciones = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'UBICACION' ORDER BY nombre")->getResultArray();
    $instLiberacion = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'SI_NO' ORDER BY nombre")->getResultArray();
    $usuarioFuncionario = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'USUARIO_FUNCIONARIO' ORDER BY nombre")->getResultArray();
    $estadoRegistro = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'ESTADO_REGISTRO' ORDER BY nombre")->getResultArray();
    $tipoLectura = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'TIPO_LECTURA' ORDER BY nombre")->getResultArray();
    
    // Normalización de campos select (¡aquí está la solución!)
    $medidor['tipo_vivienda'] = $this->mapearNombreAConcepto($medidor['tipo_vivienda'], $tipoVivienda);
    $medidor['categoria'] = $this->mapearNombreAConcepto($medidor['categoria'], $categoria);
    $medidor['ubicacion'] = $this->mapearNombreAConcepto($medidor['ubicacion'], $ubicacionOpciones);
    $medidor['inst_con_liberacion'] = $this->mapearNombreAConcepto($medidor['inst_con_liberacion'], $instLiberacion);
    $medidor['usu_funcionario'] = $this->mapearNombreAConcepto($medidor['usu_funcionario'], $usuarioFuncionario);
    $medidor['estado_registro'] = $this->mapearNombreAConcepto($medidor['estado_registro'], $estadoRegistro);
    $medidor['tipo_lectura'] = $this->mapearNombreAConcepto($medidor['tipo_lectura'], $tipoLectura);
    
            return view('medidores/edit', [
                'medidor' => $medidor,
                'tipoVivienda' => $tipoVivienda,
                'categoria' => $categoria,
                'ubicacionOpciones' => $ubicacionOpciones,
                'instLiberacion' => $instLiberacion,
                'usuarioFuncionario' => $usuarioFuncionario,
                'estadoRegistro' => $estadoRegistro,
                'tipoLectura' => $tipoLectura
            ]);
        }
        

       public function update($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        // 1. Obtener los datos actuales del medidor ANTES de procesar el POST
        // Esto es CRUCIAL para manejar la foto existente correctamente.
        $medidorActual = $this->model->find($id);
        
        if (!$medidorActual) {
            // Si el medidor no se encuentra, redirigir con un mensaje de error
            return redirect()->to('/medidores')->with('error', 'Medidor no encontrado para actualizar.');
        }

        // Obtener todos los datos del formulario POST
        // Esta línea recolecta automáticamente todos los campos del formulario,
        // sin necesidad de listarlos uno por uno como en tu código original.
        $data = $this->request->getPost();
        
        // Limpiar campos vacíos opcionales (los convierte en null)
        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }
        
        // 📌 Manejo de la foto inicial
        // 1. Verificar si se marcó para eliminar la foto existente
        $eliminarFotoActual = $this->request->getPost('eliminar_foto');
        if ($eliminarFotoActual === '1') {
            // Si hay una foto existente y se marcó para eliminar, borrarla del servidor
            if (!empty($medidorActual['foto_inicial']) && file_exists(FCPATH . 'uploads/fotos/' . $medidorActual['foto_inicial'])) {
                unlink(FCPATH . 'uploads/fotos/' . $medidorActual['foto_inicial']);
            }
            $data['foto_inicial'] = null; // Establecer el campo en la base de datos a NULL
        }

        // 2. Procesar la nueva imagen si se subió
        $foto = $this->request->getFile('foto_inicial');
        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            // Si se subió una nueva foto, eliminar la anterior si existe
            // (y no fue ya eliminada por la lógica de 'eliminar_foto')
            if (!empty($medidorActual['foto_inicial']) && file_exists(FCPATH . 'uploads/fotos/' . $medidorActual['foto_inicial']) && $eliminarFotoActual !== '1') {
                unlink(FCPATH . 'uploads/fotos/' . $medidorActual['foto_inicial']);
            }
            
            $nombreFoto = $foto->getRandomName();
            // Mover la nueva foto al directorio de subidas
            $foto->move(FCPATH . 'uploads/fotos', $nombreFoto); 
            $data['foto_inicial'] = $nombreFoto; // Asignar el nuevo nombre de la foto
        } elseif ($eliminarFotoActual !== '1' && !isset($data['foto_inicial'])) {
            // Si no se subió una nueva foto Y NO se marcó para eliminar la existente,
            // y el campo 'foto_inicial' no está presente en $data (lo cual es normal si el input file está vacío),
            // entonces aseguramos que el valor de la foto_inicial actual se mantenga.
            $data['foto_inicial'] = $medidorActual['foto_inicial'];
        }
        // Si no se subió una nueva foto y se marcó para eliminar, $data['foto_inicial'] ya es null.
        // Si se subió una nueva foto, $data['foto_inicial'] ya tiene el nuevo nombre.

        // Realizar la actualización en la base de datos
        // No es necesario instanciar el modelo de nuevo, ya está disponible a través de $this->model
        $this->model->update_auditor($id, $data);
        
        return redirect()->to(base_url('medidores'))->with('mensaje', 'Registro actualizado correctamente');
    }
    
    /**
     * Elimina un registro de medidor y su foto asociada.
     *
     * @param int $id El ID del medidor a eliminar.
     */
    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $medidor = $this->model->find($id); // Obtener datos del medidor para eliminar la foto
        if ($medidor) {
            // Eliminar la foto asociada si existe
            if (!empty($medidor['foto_inicial']) && file_exists(FCPATH . 'uploads/fotos/' . $medidor['foto_inicial'])) {
                unlink(FCPATH . 'uploads/fotos/' . $medidor['foto_inicial']);
            }
            $this->model->delete_auditor($id);
            return redirect()->to(base_url('medidores'))->with('status', 'Registro de Red de Agua Potable eliminado correctamente');
        }
        return redirect()->to(base_url('medidores'))->with('error', 'Registro no encontrado para eliminar.');
    }

    /**
     * Redirige a la vista del medidor en JVisorBolivia.
     *
     * @param int $gid El GID del medidor.
     */
  
    public function ver_medidores_ol ($gid) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        // se debe crear la variable de session para guardar el url del servidor grafico
        $i_jameuge = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=medidores_gid";
        $i_jameuge = $i_jameuge . "&gid=" . $gid;
        $i_jameuge = $i_jameuge . "&ip_host=server1.jmap4.com";
        //redirect($i_jameuge);
        //return redirect()->to('https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid&gid=1&ip_host=server1.jmap4.com');
        return redirect()->to($i_jameuge);
    }
    
     private function mapearNombreAConcepto($valor, $listaOpciones) {
    foreach ($listaOpciones as $opcion) {
        if (strcasecmp(trim($opcion['nombre']), trim($valor)) === 0) {
            return $opcion['concepto'];
        }
    }
    return $valor; // devuelve el mismo valor si no se encuentra mapeo
}
}