<?php

namespace App\Controllers;

use App\Models\ManzanaModel;

class Manzanas extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new ManzanaModel();
    }

public function index()
{
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
        $model = $this->model;
    
        $search = $this->request->getGet(); // filtros desde URL
        $page = (int) ($this->request->getVar('page') ?? 1);
        $perPage = 10;
        $offset = ($page - 1) * $perPage;
    
        // contar y filtrar
        $total = $model->getFilteredCount($search);
        $items = $model->getFilteredData($perPage, $offset, $search)->getResultArray();
    
        // generar paginador
        $pager = \Config\Services::pager();
        $pager->makeLinks($page, $perPage, $total);
    
        return view('manzanas/index', [
            'items' => $items,
            'search' => $search,
            'pager' => $pager,
            'page' => $page,
            'perPage' => $perPage,
            'total' => $total,
        ]);
    }

    public function importarShape()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
    helper(['filesystem', 'form']);

    // 1. Validar que se recibieron archivos
    $uploadedFiles = $this->request->getFileMultiple('shapefile');
    if (!$uploadedFiles || count($uploadedFiles) === 0 || !$uploadedFiles[0]->isValid()) {
        return redirect()->back()->with('error', 'No se subió ningún archivo o los archivos son inválidos.');
    }

    // 2. Crear un directorio temporal único
    $tempDir = WRITEPATH . 'uploads/shapetmp_' . uniqid();
    if (!mkdir($tempDir, 0777, true)) {
        return redirect()->back()->with('error', 'No se pudo crear el directorio temporal.');
    }

    // 3. Mover los archivos subidos al directorio temporal
    $allowedExtensions = ['shp', 'shx', 'dbf', 'prj', 'cpg', 'sbn', 'sbx'];
    foreach ($uploadedFiles as $file) {
        if ($file->isValid() && !$file->hasMoved()) {
            $ext = strtolower($file->getClientExtension());
            if (in_array($ext, $allowedExtensions)) {
                $file->move($tempDir, $file->getClientName());
            }
        }
    }

    // 4. Encontrar el archivo .shp principal
    $shpFiles = glob($tempDir . '/*.shp');
    if (empty($shpFiles)) {
        delete_files($tempDir, true);
        rmdir($tempDir);
        return redirect()->back()->with('error', 'Carga incompleta. No se encontró el archivo .shp principal.');
    }
    $shpFile = $shpFiles[0];

    // 5. Armar y ejecutar el comando ogr2ogr
    
    // LÍNEA CORREGIDA: Obtenemos la configuración directamente
    $dbConfig = config('Database')->default; 

    $pg_conn = sprintf(
        "PG:host=%s port=%s dbname=%s user=%s password=%s",
        $dbConfig['hostname'],
        $dbConfig['port'] ?? '5432',
        $dbConfig['database'],
        $dbConfig['username'],
        $dbConfig['password']
    );

    $cmd = sprintf(
    "ogr2ogr -f PostgreSQL %s %s -nln bdgeo.manzanas -append -nlt MULTIPOLYGON -lco GEOMETRY_NAME=geom",
        escapeshellarg($pg_conn),
        escapeshellarg($shpFile)
    );

    exec($cmd . ' 2>&1', $output, $exitCode);

    // 6. Borrar la carpeta temporal y su contenido
    delete_files($tempDir, true);
    rmdir($tempDir);

    // 7. Redirigir con mensaje de éxito o error
    if ($exitCode !== 0) {
        $errorMessage = 'Error al importar el Shapefile: ' . implode("\n", $output);
        return redirect()->back()->with('error', $errorMessage);
    }

    return redirect()->to(site_url('manzanas'))->with('success', 'Shapefile importado exitosamente.');
}

    public function view($id)
{
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
        $mza = $this->model->find($id);
        if (!$mza) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }

        return view('manzanas/view', ['mza' => $mza]);
    }


    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $db = \Config\Database::connect();
    $query = $db->query("SELECT DISTINCT distritos FROM bdgeo.manzanas WHERE distritos IS NOT NULL AND distritos <> '' ORDER BY distritos");
    $distritos = $query->getResultArray();
    
        return view('manzanas/create', [
            'distritos' => $distritos
            ]);
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $cod_mza = $this->request->getPost('cod_mza');
        $cod_mza = substr($cod_mza, 0, 4); // Solo primeros 4 caracteres
        $sup_area = $this->request->getPost('sup_area');
        $data = [
            'cod_mza'    => $cod_mza,
            // Si $sup_area está vacío o no es numérico, guardar NULL
            'sup_area'   => (is_numeric($sup_area) && $sup_area !== '') ? (float)$sup_area : null,
            'distritos'    => $this->request->getPost('distritos'),
            'observacion'    => $this->request->getPost('observacion')
        ];
    
        $this->model->insert($data);
    
        return redirect()->to('/manzanas')->with('mensaje', 'Registro creado correctamente');
    }


    public function edit($gid)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
            $mza = $this->model->find($gid);
    
            if (!$mza) {
                throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
            }
            
        $db = \Config\Database::connect();
    $query = $db->query("SELECT DISTINCT distritos FROM bdgeo.manzanas WHERE distritos IS NOT NULL AND distritos <> '' ORDER BY distritos");
    $distritos = $query->getResultArray();

        return view('manzanas/edit', [
            'mza' => $mza,
            'distritos' => $distritos
        ]);
    }

    public function delete($gid)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = new \App\Models\ManzanaModel();
    
        $mza = $model->find($gid);
    
        if (!$mza) {
            return redirect()->to(base_url('manzanas'))->with('error', 'Registro no encontrado.');
        }
    
        $success = $model->delete($gid);
    
        if ($success) {
            return redirect()->to(base_url('manzanas'))->with('status', 'Registro Manzana eliminado correctamente.');
        } else {
            return redirect()->to(base_url('manzanas'))->with('error', 'No se pudo eliminar el registro.');
        }
    }




    public function update($gid)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $cod_mza = $this->request->getPost('cod_mza');
        $cod_mza = substr($cod_mza, 0, 4); // Solo primeros 4 caracteres
        $sup_area = $this->request->getPost('sup_area');
        $data = [
        'cod_mza'    => $cod_mza,
        // Si $sup_area está vacío o no es numérico, guardar NULL
        'sup_area'   => (is_numeric($sup_area) && $sup_area !== '') ? (float)$sup_area : null,
        'distritos'   => $this->request->getPost('distritos'),
        'observacion' => $this->request->getPost('observacion')
        ];


        $this->model->update($gid, $data);

        return redirect()->to('/manzanas')->with('mensaje', 'Manzana actualizada correctamente.');
    }
    
    public function ver_manzanas_ol ($gid) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        // se debe crear la variable de session para guardar el url del servidor grafico
        $i_jameuge = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=manzanas_gid";
        $i_jameuge = $i_jameuge . "&gid=" . $gid;
        $i_jameuge = $i_jameuge . "&ip_host=server1.jmap4.com";
        //redirect($i_jameuge);
        //return redirect()->to('https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid&gid=1&ip_host=server1.jmap4.com');
        return redirect()->to($i_jameuge);
    }
}