<?php
namespace App\Controllers;

use App\Controllers\BaseController;
use Config\Database;

class Dashboard extends BaseController
{
    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }           
        if (!session()->get('logged_in')) {
            return redirect()->to('/login');
        }

        $db = \Config\Database::connect();

        $redAguaPotable    = $db->query("SELECT COUNT(*) as total FROM bdgeo.red_agua_potable")->getRow()->total;
        $redAlcantarillado = $db->query("SELECT COUNT(*) as total FROM bdgeo.red_alcantarillado")->getRow()->total;
        $medidores         = $db->query("SELECT COUNT(*) as total FROM bdgeo.medidores")->getRow()->total;
        $camaras           = $db->query("SELECT COUNT(*) as total FROM bdgeo.camaras_resumen")->getRow()->total;
        $valvulas          = $db->query("SELECT COUNT(*) as total FROM bdgeo.valvulas")->getRow()->total;
// =================================================================
    // INICIO DE LAS CONSULTAS OPTIMIZADAS
    // =================================================================

    // Consulta para Distritos (MUY RÁPIDA)
    $camarasPorDistrito = $db->query("
        SELECT distrito as nombre, COUNT(gid) as total
        FROM bdgeo.camaras_resumen
        WHERE distrito IS NOT NULL
        GROUP BY distrito
        ORDER BY distrito
    ")->getResultArray();

    // Consulta para OTB (MUY RÁPIDA)
    $camarasPorOTB = $db->query("
        SELECT nombres_otb as nombre, COUNT(gid) as total
        FROM bdgeo.camaras_resumen
        WHERE nombres_otb IS NOT NULL
        GROUP BY nombres_otb
        ORDER BY nombres_otb
    ")->getResultArray();

    // Consulta para Manzana (MUY RÁPIDA)
    $camarasPorManzana = $db->query("
        SELECT cod_mza as nombre, COUNT(gid) as total
        FROM bdgeo.camaras_resumen
        WHERE cod_mza IS NOT NULL
        GROUP BY cod_mza
        ORDER BY cod_mza
    ")->getResultArray();

    // Consulta para Predio (MUY RÁPIDA)
    $camarasPorPredio = $db->query("
        SELECT predio as nombre, COUNT(gid) as total
        FROM bdgeo.camaras_resumen
        WHERE predio IS NOT NULL
        GROUP BY predio
        ORDER BY predio
    ")->getResultArray();

    // =================================================================
    // FIN DE LAS CONSULTAS OPTIMIZADAS
    // =================================================================

/*        $mapaUrl = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=general&ip_host=server1.jmap4.com";*/

        $data = [
            'title'             => 'SIGAPAS',
            'redAguaPotable'    => $redAguaPotable,
            'redAlcantarillado' => $redAlcantarillado,
            'medidores'         => $medidores,
            'camaras'           => $camaras,
            'valvulas'          => $valvulas,
/*
            'mapaUrl'           => $mapaUrl,
*/
            'camarasPorDistrito'=> $camarasPorDistrito,   // singular
            'camarasPorManzana' => $camarasPorManzana,    // singular
            'camarasPorPredio'  => $camarasPorPredio,     // singular
            'camarasPorOTB'     => $camarasPorOTB
        ];

        return view('dashboard/index', $data);
    }


   

    public function cerrarSesion()
    {
        session()->destroy();
        return redirect()->to('/login');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/login');
    }
}
