<?php

namespace App\Controllers;

use App\Models\ConceptosModel;

class Conceptos extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new ConceptosModel();
    }

    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        
        $filtros = [
            'concepto'     => $this->request->getGet('concepto'),
            'nombre'       => $this->request->getGet('nombre'),
            'tipoconcepto' => $this->request->getGet('tipoconcepto'),
            'clase'        => $this->request->getGet('clase'),
            'referencia'   => $this->request->getGet('referencia'),
        ];

        $porPagina = 10;

        $data['items'] = $this->model
            ->buscar($filtros)
            ->orderBy('concepto', 'ASC')
            ->paginate($porPagina);

        $data['pager'] = $this->model->pager;
        $data['search'] = $filtros;

        return view('conceptos/index', $data);
    }

    public function create()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        return view('conceptos/create');
    }

    public function store()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();
        
        // Limpiar vacíos como null (especialmente fechas)
        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }
        
        $this->model->insert($data);

        return redirect()->to('/conceptos')->with('mensaje', 'Concepto creado correctamente');
    }

    public function edit($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $item = $this->model->find($id);
        if (!$item) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Registro no encontrado");
        }

        return view('conceptos/edit', ['item' => $item]);
    }

    public function update($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $data = $this->request->getPost();

        foreach ($data as $key => $value) {
            $data[$key] = (trim($value) === '') ? null : $value;
        }

        $this->model->update($id, $data);
        return redirect()->to('/conceptos')->with('mensaje', 'Concepto actualizado correctamente');
    }

    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $this->model->delete($id);
        return redirect()->to('/conceptos')->with('status', 'Concepto eliminado correctamente');
    }
}
