<?php namespace App\Controllers;

use App\Models\CamarasModel;

class Camaras extends BaseController
{
    protected $CamarasModel;
    

    public function __construct()
    {
        $this->CamarasModel = new CamarasModel();
        $this->db = \Config\Database::connect();
    }


    public function index()
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $model = $this->CamarasModel;
        $search = $this->request->getGet();
    
        $page = (int) ($this->request->getVar('page') ?? 1);
        $perPage = 10;
        $offset = ($page - 1) * $perPage;
        
        // CORREGIDO: Capturar el campo y la dirección de ordenamiento
        $orderBy = $this->request->getGet('order_by') ?? 'codigo';
        $orderDirection = $this->request->getGet('order_direction') ?? 'DESC';

        $total = $model->getFilteredCount($search);
        // CORREGIDO: Pasar los parámetros de ordenamiento al modelo
        $items = $model->getFilteredData($perPage, $offset, $search, $orderBy, $orderDirection);
        
        $pager = \Config\Services::pager();
        $pager->makeLinks($page, $perPage, $total);
        
        return view('camaras/index', [
            'items' => $items,
            'pager' => $pager,
            'search' => $search,
            'orderBy' => $orderBy, // Pasar el campo de orden a la vista
            'orderDirection' => $orderDirection // Pasar la dirección de orden a la vista
        ]);
    }

  public function importarShape()
  {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }           
    helper(['filesystem', 'form']);

    // 1. Validar que se recibieron archivos
    $uploadedFiles = $this->request->getFileMultiple('shapefile');
    if (!$uploadedFiles || count($uploadedFiles) === 0 || !$uploadedFiles[0]->isValid()) {
        return redirect()->back()->with('error', 'No se subió ningún archivo o los archivos son inválidos.');
    }

    // 2. Crear un directorio temporal único
    $tempDir = WRITEPATH . 'uploads/shapetmp_' . uniqid();
    if (!mkdir($tempDir, 0777, true)) {
        return redirect()->back()->with('error', 'No se pudo crear el directorio temporal.');
    }

    // 3. Mover los archivos subidos al directorio temporal
    $allowedExtensions = ['shp', 'shx', 'dbf', 'prj', 'cpg', 'sbn', 'sbx'];
    foreach ($uploadedFiles as $file) {
        if ($file->isValid() && !$file->hasMoved()) {
            $ext = strtolower($file->getClientExtension());
            if (in_array($ext, $allowedExtensions)) {
                $file->move($tempDir, $file->getClientName());
            }
        }
    }

    // 4. Encontrar el archivo .shp principal
    $shpFiles = glob($tempDir . '/*.shp');
    if (empty($shpFiles)) {
        delete_files($tempDir, true);
        rmdir($tempDir);
        return redirect()->back()->with('error', 'Carga incompleta. No se encontró el archivo .shp principal.');
    }
    $shpFile = $shpFiles[0];

    // 5. Armar y ejecutar el comando ogr2ogr
    
    // LÍNEA CORREGIDA: Obtenemos la configuración directamente
    $dbConfig = config('Database')->default; 

    $pg_conn = sprintf(
        "PG:host=%s port=%s dbname=%s user=%s password=%s",
        $dbConfig['hostname'],
        $dbConfig['port'] ?? '5432',
        $dbConfig['database'],
        $dbConfig['username'],
        $dbConfig['password']
    );

    $cmd = sprintf(
    "ogr2ogr -f PostgreSQL %s %s -nln bdgeo.camaras -append -nlt POINT -lco GEOMETRY_NAME=geom",
        escapeshellarg($pg_conn),
        escapeshellarg($shpFile)
    );

    exec($cmd . ' 2>&1', $output, $exitCode);

    // 6. Borrar la carpeta temporal y su contenido
    delete_files($tempDir, true);
    rmdir($tempDir);

    // 7. Redirigir con mensaje de éxito o error
    if ($exitCode !== 0) {
        $errorMessage = 'Error al importar el Shapefile: ' . implode("\n", $output);
        return redirect()->back()->with('error', $errorMessage);
    }

    return redirect()->to(site_url('camaras'))->with('success', 'Shapefile importado exitosamente.');
}

    public function create()
    {
        return view('camaras/create');
    }

    public function store()
    {
        $emptyToNull = function ($value) {
            return trim($value) === '' ? null : $value;
        };

        $data = [
            'codigo' => $this->request->getPost('codigo'),
            'otb' => $this->request->getPost('otb'),
            'distrito' => $emptyToNull($this->request->getPost('distrito')),
            'nombre_calle' => $this->request->getPost('nombre_calle'),
            'ubicacion' => $this->request->getPost('ubicacion'),
            'nom_cuenca' => $this->request->getPost('nom_cuenca'),
            'este' => $emptyToNull($this->request->getPost('este')),
            'norte' => $emptyToNull($this->request->getPost('norte')),
            'altura' => $emptyToNull($this->request->getPost('altura')),
            'diametro' => $emptyToNull($this->request->getPost('diametro')),
            'forma' => $this->request->getPost('forma'),
            'cota' => $emptyToNull($this->request->getPost('cota')),
            'caida' => $emptyToNull($this->request->getPost('caida')),
            'estado' => $this->request->getPost('estado'),
            'numero_cruce' => $emptyToNull($this->request->getPost('numero_cruce')),
            'material_tapa' => $this->request->getPost('material_tapa'),
            'cod_activos_fijos' => $this->request->getPost('codigo_activos_fijos'),
            'fecha_instalacion' => $emptyToNull($this->request->getPost('fecha_instalacion')),
            'fecha_habilitacion' => $emptyToNull($this->request->getPost('fecha_habilitacion')),
            'valor_instalacion' => $emptyToNull($this->request->getPost('valor_instalacion')),
            'tipo_inversion' => $this->request->getPost('tipo_inversion'),
            'nom_proyecto' => $this->request->getPost('nombre_proyecto'),
            'emp_responsable' => $this->request->getPost('emp_responsable'),
            'supervisor' => $this->request->getPost('supervisor'),
            'encargado_lev' => $this->request->getPost('encargado_lev'),
            'resp_catastro' => $this->request->getPost('resp_catastro'),
            'observaciones' => $this->request->getPost('observaciones'),
            'gestion' => $this->request->getPost('gestion'),
        ];

        $this->CamarasModel->insert_auditor($data);

        return redirect()->to(base_url('camaras'))->with('mensaje', 'Cámara registrada exitosamente.');
    }

    public function edit($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $camara = $this->CamarasModel->find($id);

        if (!$camara) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException("Cámara no encontrada: $id");
        }

            $db = \Config\Database::connect();

    $ubiCamara = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'UBICACION_CAMARA' ORDER BY nombre")->getResultArray();
    $estadoCamara = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'ESTADO_CAMARA' ORDER BY nombre")->getResultArray();
    $formaCamara = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'CUERPO' ORDER BY nombre")->getResultArray();
    $caidaCamara = $db->query("SELECT concepto, nombre FROM bdgeo.conceptos WHERE tipoconcepto = 'CON_SIN_CAIDA' ORDER BY nombre")->getResultArray();
    
    // Normalización de campos select (¡aquí está la solución!)
    $camara['ubicacion'] = $this->mapearNombreAConcepto($camara['ubicacion'], $ubiCamara);
    $camara['estado'] = $this->mapearNombreAConcepto($camara['estado'], $estadoCamara);
    $camara['forma'] = $this->mapearNombreAConcepto($camara['forma'], $formaCamara);
    $camara['caida'] = $this->mapearNombreAConcepto($camara['caida'], $caidaCamara);
    
        return view('camaras/edit', [
            'camara' => $camara,
            'ubiCamara' => $ubiCamara,
            'estadoCamara' => $estadoCamara,
            'formaCamara' => $formaCamara,
            'caidaCamara' => $caidaCamara
        ]);
    }

  public function update($id)
{
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
    $data = $this->request->getPost();

    // Campos tipo entero
    $camposEnteros = [
        'numero_cruce',
        'altura',
        'diametro',
        'cota',
        // 'caida',
        'este',
        'norte',
        'valor_instalacion'
    ];

    // Campos tipo fecha
    $camposFecha = [
        'fecha_instalacion',
        'fecha_habilitacion'
    ];

    // Limpiar enteros
    foreach ($camposEnteros as $campo) {
        if (isset($data[$campo]) && $data[$campo] === '') {
            $data[$campo] = null;
        } elseif (isset($data[$campo])) {
            $data[$campo] = (int) $data[$campo];
        }
    }

    // Limpiar fechas
    foreach ($camposFecha as $campo) {
        if (isset($data[$campo]) && $data[$campo] === '') {
            $data[$campo] = null;
        }
    }

    $this->CamarasModel->update_auditor($id, $data);
    return redirect()->to('/camaras');
}



    public function view($id)
{
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }         
    $camaraModel = new \App\Models\CamarasModel();
    $camara = $camaraModel->find($id);

    if (!$camara) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Cámara no encontrada");
    }

    return view('camaras/view', ['camara' => $camara]);
}


    public function delete($id)
    {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
        $this->CamarasModel->delete_auditor($id);
        return redirect()->to('/camaras')->with('status', 'Registro eliminado correctamente');
    }
    
    public function ver_camaras_ol ($gid) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }     
        // se debe crear la variable de session para guardar el url del servidor grafico
        $i_jameuge = "https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=camaras_gid";
        $i_jameuge = $i_jameuge . "&gid=" . $gid;
        $i_jameuge = $i_jameuge . "&ip_host=server1.jmap4.com";
        //redirect($i_jameuge);
        //return redirect()->to('https://server1.jmap4.com/jvisorbolivia/index.html?tipo_consulta=predios_gid&gid=1&ip_host=server1.jmap4.com');
        return redirect()->to($i_jameuge);
    }
    
    
    private function mapearNombreAConcepto($valor, $listaOpciones) {
        if ((session()->get('logged_in') !== true) || (session()->get('tiene_grupo') !== 'SI') ) {
            return redirect()->to('/login')->with('mensaje', 'FALTA asignarle ROLES');
        }             
    foreach ($listaOpciones as $opcion) {
        if (strcasecmp(trim($opcion['nombre']), trim($valor)) === 0) {
            return $opcion['concepto'];
        }
        }
    return $valor; // devuelve el mismo valor si no se encuentra mapeo
    }

}

